/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClusters;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordIteratorClass<REC extends ORecordInternal<?>>
extends ORecordIteratorClusters<REC> {
    protected final OClass targetClass;
    protected boolean polymorphic;

    public ORecordIteratorClass(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase, String iClassName, boolean iPolymorphic) {
        super(iDatabase, iLowLevelDatabase);
        this.targetClass = this.database.getMetadata().getSchema().getClass(iClassName);
        if (this.targetClass == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' was not found in database schema");
        }
        this.polymorphic = iPolymorphic;
        this.clusterIds = this.polymorphic ? this.targetClass.getPolymorphicClusterIds() : this.targetClass.getClusterIds();
        this.config();
    }

    @Override
    public REC next() {
        return (REC)((ORecordInternal)super.next().getRecord());
    }

    @Override
    public REC previous() {
        return (REC)((ORecordInternal)super.previous().getRecord());
    }

    @Override
    protected boolean include(ORecord<?> record) {
        return record instanceof ODocument && this.targetClass.isSuperClassOf(((ODocument)record).getSchemaClass());
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }
}

