/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectIteratorClass<T>
implements Iterator<T>,
Iterable<T> {
    private ODatabaseObject database;
    private ORecordIteratorClass<ODocument> underlying;
    private String fetchPlan;

    public OObjectIteratorClass(ODatabaseObject iDatabase, ODatabaseRecordAbstract iUnderlyingDatabase, String iClusterName, boolean iPolymorphic) {
        this.database = iDatabase;
        this.underlying = new ORecordIteratorClass((ODatabaseRecord)iDatabase.getUnderlying(), iUnderlyingDatabase, iClusterName, iPolymorphic);
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public T next() {
        return this.next(this.fetchPlan);
    }

    public T next(String iFetchPlan) {
        return (T)this.database.getUserObjectByRecord((ORecordInternal<?>)this.underlying.next(), iFetchPlan);
    }

    @Override
    public void remove() {
        this.underlying.remove();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public OObjectIteratorClass<T> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }
}

