/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.intent;

import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.record.ORecordInternal;

public class OIntentMassiveInsert
implements OIntent {
    private boolean previousLevel1CacheEnabled;
    private boolean previousLevel2CacheEnabled;
    private boolean previousRetainRecords;
    private boolean previousRetainObjects;

    public void begin(ODatabaseRaw iDatabase, Object ... iArgs) {
        this.previousLevel1CacheEnabled = iDatabase.getDatabaseOwner().getLevel1Cache().isEnabled();
        iDatabase.getDatabaseOwner().getLevel1Cache().setEnable(false);
        this.previousLevel2CacheEnabled = iDatabase.getDatabaseOwner().getLevel2Cache().isEnabled();
        iDatabase.getDatabaseOwner().getLevel2Cache().setEnable(false);
        ODatabaseComplex<ORecordInternal<?>> ownerDb = iDatabase.getDatabaseOwner();
        if (ownerDb instanceof ODatabaseRecord) {
            this.previousRetainRecords = ownerDb.isRetainRecords();
            ownerDb.setRetainRecords(false);
        }
        while (ownerDb.getDatabaseOwner() != ownerDb) {
            ownerDb = ownerDb.getDatabaseOwner();
        }
        if (ownerDb instanceof ODatabasePojoAbstract) {
            this.previousRetainObjects = ((ODatabasePojoAbstract)ownerDb).isRetainObjects();
            ((ODatabasePojoAbstract)ownerDb).setRetainObjects(false);
        }
    }

    public void end(ODatabaseRaw iDatabase) {
        iDatabase.getDatabaseOwner().getLevel1Cache().setEnable(this.previousLevel1CacheEnabled);
        iDatabase.getDatabaseOwner().getLevel2Cache().setEnable(this.previousLevel2CacheEnabled);
        ODatabaseComplex<ORecordInternal<?>> ownerDb = iDatabase.getDatabaseOwner();
        if (ownerDb instanceof ODatabaseRecord) {
            ownerDb.setRetainRecords(this.previousRetainRecords);
        }
        while (ownerDb.getDatabaseOwner() != ownerDb) {
            ownerDb = ownerDb.getDatabaseOwner();
        }
        if (ownerDb instanceof ODatabasePojoAbstract) {
            ((ODatabasePojoAbstract)ownerDb).setRetainObjects(this.previousRetainObjects);
        }
    }
}

