/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexRemoteMultiValue;
import com.orientechnologies.orient.core.index.OIndexRemoteOneValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexManagerRemote
extends OIndexManagerAbstract {
    private static final String QUERY_CREATE = "create index %s %s %s";
    private static final String QUERY_DROP = "drop index %s";

    public OIndexManagerRemote(ODatabaseRecord iDatabase) {
        super(iDatabase);
    }

    @Override
    protected OIndex<?> getIndexInstance(OIndex<?> iIndex) {
        if (iIndex instanceof OIndexMultiValues) {
            return new OIndexRemoteMultiValue(iIndex.getName(), iIndex.getType(), iIndex.getIdentity(), iIndex.getDefinition(), this.getConfiguration());
        }
        return new OIndexRemoteOneValue(iIndex.getName(), iIndex.getType(), iIndex.getIdentity(), iIndex.getDefinition(), this.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndex createIndex(String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        OIndex oIndex;
        String createIndexDDL = iIndexDefinition != null ? iIndexDefinition.toCreateIndexDDL(iName, iType) : new OSimpleKeyIndexDefinition().toCreateIndexDDL(iName, iType);
        this.acquireExclusiveLock();
        try {
            if (iProgressListener != null) {
                iProgressListener.onBegin(this, 0L);
            }
            this.getDatabase().command(new OCommandSQL(createIndexDDL)).execute(new Object[0]);
            this.document.setIdentity(new ORecordId(this.document.getDatabase().getStorage().getConfiguration().indexMgrRecordId));
            if (iProgressListener != null) {
                iProgressListener.onCompletition(this, true);
            }
            this.reload();
            oIndex = (OIndex)this.indexes.get(iName.toLowerCase());
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexManager dropIndex(String iIndexName) {
        OIndexManagerRemote oIndexManagerRemote;
        this.acquireExclusiveLock();
        try {
            String text = String.format(QUERY_DROP, iIndexName);
            this.getDatabase().command(new OCommandSQL(text)).execute(new Object[0]);
            this.indexes.remove(iIndexName.toLowerCase());
            this.reload();
            oIndexManagerRemote = this;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexManagerRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            Collection idxs = (Collection)this.document.field("indexes");
            this.indexes.clear();
            this.classPropertyIndex.clear();
            if (idxs != null) {
                for (ODocument d : idxs) {
                    Object index = OIndexFactory.instance().newInstance(this.getDatabase(), (String)d.field("type"));
                    index.loadFromConfiguration(d);
                    this.addIndexInternal((OIndexInternal<?>)index);
                }
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument toStream() {
        ODocument oDocument;
        this.acquireExclusiveLock();
        try {
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                ORecordTrackedSet idxs = new ORecordTrackedSet(this.document);
                for (OIndexInternal i : this.indexes.values()) {
                    idxs.add(i.updateConfiguration());
                }
                this.document.field("indexes", idxs, OType.EMBEDDEDSET);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
                throw throwable;
            }
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            this.document.setDirty();
            oDocument = this.document;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oDocument;
    }
}

