/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexFullText
extends OIndexMultiValues {
    private static final String CONFIG_STOP_WORDS = "stopWords";
    private static final String CONFIG_IGNORE_CHARS = "ignoreChars";
    private static String DEF_CLUSTER_NAME = "FullTextIndex";
    private static String DEF_IGNORE_CHARS = " \r\n\t:;,.|+*/\\=!?[]()'\"";
    private static String DEF_STOP_WORDS = "the in a at as and or for his her him this that what which while up with be was is";
    private final String ignoreChars = DEF_IGNORE_CHARS;
    private final Set<String> stopWords = new HashSet<String>(OStringSerializerHelper.split(DEF_STOP_WORDS, ' ', new char[0]));

    public OIndexFullText() {
        super("FULLTEXT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexDocument(ODocument iDocument) {
        for (String fieldName : iDocument.fieldNames()) {
            Object fieldValue = iDocument.field(fieldName);
            this.put(fieldValue, iDocument);
        }
        this.acquireExclusiveLock();
        try {
            this.map.save();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexFullText put(Object iKey, OIdentifiable iSingleValue) {
        if (iKey == null) {
            return this;
        }
        List<String> words = this.splitIntoWords(iKey.toString());
        for (String word : words) {
            Object var8_7;
            this.acquireExclusiveLock();
            try {
                Set refs = (Set)this.map.get(word);
                if (refs == null) {
                    refs = new OMVRBTreeRIDSet().setAutoConvert(false);
                }
                refs.add(iSingleValue);
                this.map.put(word, refs);
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            {
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object iKey, OIdentifiable value) {
        List<String> words = this.splitIntoWords(iKey.toString());
        boolean removed = false;
        for (String word : words) {
            Object var9_8;
            this.acquireExclusiveLock();
            try {
                Object recs = this.get(word);
                if (recs != null && !recs.isEmpty() && recs.remove(value)) {
                    if (recs.isEmpty()) {
                        this.map.remove(iKey);
                    } else {
                        this.map.put(iKey, recs);
                    }
                    removed = true;
                }
                var9_8 = null;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            {
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument updateConfiguration() {
        super.updateConfiguration();
        this.configuration.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.configuration.field(CONFIG_IGNORE_CHARS, this.ignoreChars);
            this.configuration.field(CONFIG_STOP_WORDS, this.stopWords);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
            throw throwable;
        }
        this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
        return this.configuration;
    }

    private List<String> splitIntoWords(String iKey) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> words = OStringSerializerHelper.split(iKey, ' ', new char[0]);
        StringBuilder buffer = new StringBuilder();
        for (String word : words) {
            buffer.setLength(0);
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                boolean ignore = false;
                for (int k = 0; k < this.ignoreChars.length(); ++k) {
                    if (c != this.ignoreChars.charAt(k)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                buffer.append(c);
            }
            word = buffer.toString();
            if (this.stopWords.contains(word)) continue;
            result.add(word);
        }
        return result;
    }
}

