/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.factory.ODynamicFactory;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.metadata.schema.OClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexFactory
extends ODynamicFactory<String, Class<? extends OIndexInternal<?>>> {
    private static final OIndexFactory instance = new OIndexFactory();

    protected OIndexFactory() {
        this.register(OClass.INDEX_TYPE.UNIQUE.toString(), OIndexUnique.class);
        this.register(OClass.INDEX_TYPE.NOTUNIQUE.toString(), OIndexNotUnique.class);
        this.register(OClass.INDEX_TYPE.FULLTEXT.toString(), OIndexFullText.class);
        this.register(OClass.INDEX_TYPE.DICTIONARY.toString(), OIndexDictionary.class);
    }

    public <T extends OIndexInternal<?>> T newInstance(ODatabaseRecord iDatabase, String iIndexType) {
        if (iIndexType == null) {
            throw new IllegalArgumentException("Index type is null");
        }
        Class indexClass = (Class)this.registry.get(iIndexType);
        if (indexClass == null) {
            throw new OConfigurationException("Index type '" + iIndexType + "' is not configured");
        }
        try {
            return (T)((OIndexInternal)indexClass.newInstance());
        }
        catch (Exception e) {
            throw new OConfigurationException("Cannot create index type '" + iIndexType + "'", e);
        }
    }

    public static OIndexFactory instance() {
        return instance;
    }
}

