/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OClassIndexManager
extends ODocumentHookAbstract {
    public boolean onRecordBeforeCreate(ODocument iRecord) {
        iRecord = this.checkForLoading(iRecord);
        this.checkIndexedProperties(iRecord);
        return false;
    }

    public void onRecordAfterCreate(ODocument iRecord) {
        OClass cls = (iRecord = this.checkForLoading(iRecord)).getSchemaClass();
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        oIndex.put(keyItem, iRecord.placeholder());
                    }
                    continue;
                }
                if (key == null) continue;
                oIndex.put(key, iRecord.placeholder());
            }
        }
    }

    public boolean onRecordBeforeUpdate(ODocument iRecord) {
        iRecord = this.checkForLoading(iRecord);
        this.checkIndexedProperties(iRecord);
        return false;
    }

    public void onRecordAfterUpdate(ODocument iRecord) {
        HashSet<String> dirtyFields;
        OClass cls = (iRecord = this.checkForLoading(iRecord)).getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()))).isEmpty()) {
            block0: for (OIndex oIndex : indexes) {
                OIndexDefinition indexDefinition = oIndex.getDefinition();
                List<String> indexFields = indexDefinition.getFields();
                for (String indexField : indexFields) {
                    if (!dirtyFields.contains(indexField)) continue;
                    ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
                    for (String field : indexFields) {
                        if (dirtyFields.contains(field)) {
                            origValues.add(iRecord.getOriginalValue(field));
                            continue;
                        }
                        origValues.add(iRecord.field(field));
                    }
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    if (origValue instanceof Collection && newValue instanceof Collection) {
                        HashSet valuesToRemove = new HashSet((Collection)origValue);
                        HashSet valuesToAdd = new HashSet((Collection)newValue);
                        valuesToRemove.removeAll((Collection)newValue);
                        valuesToAdd.removeAll((Collection)origValue);
                        for (Object valueToRemove : valuesToRemove) {
                            if (valueToRemove == null) continue;
                            oIndex.remove(valueToRemove, iRecord);
                        }
                        for (Object valueToAdd : valuesToAdd) {
                            if (valueToAdd == null) continue;
                            oIndex.put(valueToAdd, iRecord);
                        }
                        continue block0;
                    }
                    if (origValue instanceof Collection) {
                        for (Object origValueItem : (Collection)origValue) {
                            if (origValueItem == null) continue;
                            oIndex.remove(origValueItem, iRecord);
                        }
                    } else if (origValue != null) {
                        oIndex.remove(origValue, iRecord);
                    }
                    if (newValue instanceof Collection) {
                        for (Object newValueItem : (Collection)newValue) {
                            oIndex.put(newValueItem, iRecord.placeholder());
                        }
                        continue block0;
                    }
                    if (newValue == null) continue block0;
                    oIndex.put(newValue, iRecord.placeholder());
                    continue block0;
                }
            }
        }
        if (iRecord.isTrackingChanges()) {
            iRecord.setTrackingChanges(false);
            iRecord.setTrackingChanges(true);
        }
    }

    public boolean onRecordBeforeDelete(ODocument iDocument) {
        if (iDocument.fields() == 0) {
            iDocument.reload();
        }
        return false;
    }

    public void onRecordAfterDelete(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        ArrayList indexes = new ArrayList(cls.getIndexes());
        if (!indexes.isEmpty()) {
            HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()));
            if (!dirtyFields.isEmpty()) {
                Iterator indexIterator = indexes.iterator();
                block0: while (indexIterator.hasNext()) {
                    OIndex oIndex = (OIndex)indexIterator.next();
                    OIndexDefinition indexDefinition = oIndex.getDefinition();
                    List<String> indexFields = indexDefinition.getFields();
                    for (String indexField : indexFields) {
                        if (!dirtyFields.contains(indexField)) continue;
                        ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
                        for (String field : indexFields) {
                            if (dirtyFields.contains(field)) {
                                origValues.add(iRecord.getOriginalValue(field));
                                continue;
                            }
                            origValues.add(iRecord.field(field));
                        }
                        Object origValue = indexDefinition.createValue(origValues);
                        if (origValue instanceof Collection) {
                            for (Object valueItem : (Collection)origValue) {
                                if (valueItem == null) continue;
                                oIndex.remove(valueItem, iRecord);
                            }
                        } else if (origValue != null) {
                            oIndex.remove(origValue, iRecord);
                        }
                        indexIterator.remove();
                        continue block0;
                    }
                }
            }
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        oIndex.remove(keyItem, iRecord);
                    }
                    continue;
                }
                if (key == null) continue;
                oIndex.remove(key, iRecord);
            }
        }
        if (iRecord.isTrackingChanges()) {
            iRecord.setTrackingChanges(false);
            iRecord.setTrackingChanges(true);
        }
    }

    private void checkIndexedProperties(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        for (OIndex oIndex : indexes) {
            Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
            if (key instanceof Collection) {
                for (Object keyItem : (Collection)key) {
                    oIndex.checkEntry(iRecord, keyItem);
                }
                continue;
            }
            oIndex.checkEntry(iRecord, key);
        }
    }

    private ODocument checkForLoading(ODocument iRecord) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                return (ODocument)iRecord.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OIndexException("Error during loading of record with id : " + iRecord.getIdentity());
            }
        }
        return iRecord;
    }
}

