/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.id;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordId
implements ORID {
    private static final long serialVersionUID = 247070594054408657L;
    public static final int PERSISTENT_SIZE = 10;
    public static final ORecordId EMPTY_RECORD_ID = new ORecordId();
    public static final byte[] EMPTY_RECORD_ID_STREAM = EMPTY_RECORD_ID.toStream();
    public int clusterId = -1;
    public long clusterPosition = -1L;

    public ORecordId() {
    }

    public ORecordId(int iClusterId, long iPosition) {
        this.clusterId = iClusterId;
        this.checkClusterLimits();
        this.clusterPosition = iPosition;
    }

    public ORecordId(int iClusterIdId) {
        this.clusterId = iClusterIdId;
        this.checkClusterLimits();
    }

    public ORecordId(String iRecordId) {
        this.fromString(iRecordId);
    }

    public ORecordId(ORID parentRid) {
        this.clusterId = parentRid.getClusterId();
        this.clusterPosition = parentRid.getClusterPosition();
    }

    @Override
    public void reset() {
        this.clusterId = -1;
        this.clusterPosition = -1L;
    }

    @Override
    public boolean isValid() {
        return this.clusterPosition != -1L;
    }

    @Override
    public boolean isPersistent() {
        return this.clusterPosition > -1L;
    }

    @Override
    public boolean isNew() {
        return this.clusterPosition < 0L;
    }

    @Override
    public boolean isTemporary() {
        return this.clusterId != -1 && this.clusterPosition < -1L;
    }

    public String toString() {
        return ORecordId.generateString(this.clusterId, this.clusterPosition);
    }

    @Override
    public StringBuilder toString(StringBuilder iBuffer) {
        if (iBuffer == null) {
            iBuffer = new StringBuilder();
        }
        iBuffer.append('#');
        iBuffer.append(this.clusterId);
        iBuffer.append(':');
        iBuffer.append(this.clusterPosition);
        return iBuffer;
    }

    public static String generateString(int iClusterId, long iPosition) {
        StringBuilder buffer = new StringBuilder(12);
        buffer.append('#');
        buffer.append(iClusterId);
        buffer.append(':');
        buffer.append(iPosition);
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clusterId;
        result = 31 * result + (int)(this.clusterPosition ^ this.clusterPosition >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OIdentifiable)) {
            return false;
        }
        ORecordId other = (ORecordId)((OIdentifiable)obj).getIdentity();
        if (this.clusterId != other.clusterId) {
            return false;
        }
        return this.clusterPosition == other.clusterPosition;
    }

    @Override
    public int compareTo(OIdentifiable iOther) {
        if (iOther == this) {
            return 0;
        }
        if (iOther == null) {
            return 1;
        }
        ORID other = iOther.getIdentity();
        if (this.clusterId == other.getClusterId()) {
            if (this.clusterPosition == other.getClusterPosition()) {
                return 0;
            }
            if (this.clusterPosition > other.getClusterPosition()) {
                return 1;
            }
            if (this.clusterPosition < other.getClusterPosition()) {
                return -1;
            }
        } else if (this.clusterId > other.getClusterId()) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compare(OIdentifiable iObj1, OIdentifiable iObj2) {
        if (iObj1 == iObj2) {
            return 0;
        }
        if (iObj1 != null) {
            return iObj1.compareTo(iObj2);
        }
        return -1;
    }

    @Override
    public ORecordId copy() {
        return new ORecordId(this.clusterId, this.clusterPosition);
    }

    private void checkClusterLimits() {
        if (this.clusterId < -1) {
            throw new ODatabaseException("RecordId cannot support negative cluster id. You've used: " + this.clusterId);
        }
        if (this.clusterId > Short.MAX_VALUE) {
            throw new ODatabaseException("RecordId cannot support cluster id major than 32767. You've used: " + this.clusterId);
        }
    }

    public ORecordId fromStream(InputStream iStream) throws IOException {
        this.clusterId = OBinaryProtocol.bytes2short(iStream);
        this.clusterPosition = OBinaryProtocol.bytes2long(iStream);
        return this;
    }

    public ORecordId fromStream(OMemoryStream iStream) {
        this.clusterId = iStream.getAsShort();
        this.clusterPosition = iStream.getAsLong();
        return this;
    }

    @Override
    public ORecordId fromStream(byte[] iBuffer) {
        if (iBuffer != null) {
            this.clusterId = OBinaryProtocol.bytes2short(iBuffer, 0);
            this.clusterPosition = OBinaryProtocol.bytes2long(iBuffer, 2);
        }
        return this;
    }

    @Override
    public int toStream(OutputStream iStream) throws IOException {
        int beginOffset = OBinaryProtocol.short2bytes((short)this.clusterId, iStream);
        OBinaryProtocol.long2bytes(this.clusterPosition, iStream);
        return beginOffset;
    }

    public int toStream(OMemoryStream iStream) throws IOException {
        int beginOffset = OBinaryProtocol.short2bytes((short)this.clusterId, iStream);
        OBinaryProtocol.long2bytes(this.clusterPosition, iStream);
        return beginOffset;
    }

    @Override
    public byte[] toStream() {
        byte[] buffer = new byte[10];
        OBinaryProtocol.short2bytes((short)this.clusterId, buffer, 0);
        OBinaryProtocol.long2bytes(this.clusterPosition, buffer, 2);
        return buffer;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public long getClusterPosition() {
        return this.clusterPosition;
    }

    public void fromString(String iRecordId) {
        if (iRecordId != null) {
            iRecordId = iRecordId.trim();
        }
        if (iRecordId == null || iRecordId.isEmpty()) {
            this.clusterId = -1;
            this.clusterPosition = -1L;
            return;
        }
        if (!OStringSerializerHelper.contains(iRecordId, ':')) {
            throw new IllegalArgumentException("Argument '" + iRecordId + "' is not a RecordId in form of string. Format must be: <cluster-id>:<cluster-position>");
        }
        List<String> parts = OStringSerializerHelper.split(iRecordId, ':', '#');
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Argument received '" + iRecordId + "' is not a RecordId in form of string. Format must be: #<cluster-id>:<cluster-position>. Example: #3:12");
        }
        this.clusterId = Integer.parseInt(parts.get(0));
        this.checkClusterLimits();
        this.clusterPosition = Long.parseLong(parts.get(1));
    }

    public void copyFrom(ORID iSource) {
        if (iSource == null) {
            throw new IllegalArgumentException("Source is null");
        }
        this.clusterId = iSource.getClusterId();
        this.clusterPosition = iSource.getClusterPosition();
    }

    @Override
    public String next() {
        return ORecordId.generateString(this.clusterId, this.clusterPosition + 1L);
    }

    @Override
    public ORID getIdentity() {
        return this;
    }

    @Override
    public ORecord<?> getRecord() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (db == null) {
            throw new ODatabaseException("No database found in current thread local space. If you manually control databases over threads assure to set the current database before to use it by calling: ODatabaseRecordThreadLocal.INSTANCE.set(db);");
        }
        return (ORecord)db.load(this);
    }
}

