/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.fetch.object;

import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.object.OLazyObjectList;
import com.orientechnologies.orient.core.db.object.OLazyObjectMap;
import com.orientechnologies.orient.core.db.object.OLazyObjectSet;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.OFetchException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectFetchContext
implements OFetchContext {
    protected final String fetchPlan;
    protected final boolean lazyLoading;
    protected final OEntityManager entityManager;
    protected final OUserObject2RecordHandler obj2RecHandler;

    public OObjectFetchContext(String iFetchPlan, boolean iLazyLoading, OEntityManager iEntityManager, OUserObject2RecordHandler iObj2RecHandler) {
        this.fetchPlan = iFetchPlan;
        this.lazyLoading = iLazyLoading;
        this.obj2RecHandler = iObj2RecHandler;
        this.entityManager = iEntityManager;
    }

    @Override
    public void onBeforeMap(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
        Map map = (Map)iRootRecord.field(iFieldName);
        HashMap target = this.lazyLoading ? new OLazyObjectMap(iRootRecord, map).setFetchPlan(this.fetchPlan) : new HashMap();
        OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, target);
    }

    @Override
    public void onBeforeArray(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject, OIdentifiable[] iArray) throws OFetchException {
        OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, Array.newInstance(iRootRecord.getSchemaClass().getProperty(iFieldName).getLinkedClass().getJavaClass(), iArray.length));
    }

    @Override
    public void onAfterArray(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onAfterMap(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onBeforeDocument(ORecordSchemaAware<?> iRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onAfterDocument(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onBeforeCollection(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject, Collection<?> iCollection) throws OFetchException {
        Collection<Object> target;
        Class<?> type = OObjectSerializerHelper.getFieldType(iUserObject, iFieldName);
        if (Set.class.isAssignableFrom(type)) {
            target = this.lazyLoading ? new OLazyObjectSet(iRootRecord, iCollection).setFetchPlan(this.fetchPlan) : new HashSet(iCollection);
        } else {
            Collection<Object> list = iCollection;
            target = this.lazyLoading ? new OLazyObjectList(iRootRecord, list).setFetchPlan(this.fetchPlan) : new ArrayList<Object>(list);
        }
        OObjectSerializerHelper.setFieldValue(iUserObject, iFieldName, target);
    }

    @Override
    public void onAfterCollection(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) throws OFetchException {
    }

    @Override
    public void onAfterFetch(ORecordSchemaAware<?> iRootRecord) throws OFetchException {
    }

    @Override
    public void onBeforeFetch(ORecordSchemaAware<?> iRootRecord) throws OFetchException {
    }

    @Override
    public void onBeforeStandardField(Object iFieldValue, String iFieldName, Object iUserObject) {
    }

    @Override
    public void onAfterStandardField(Object iFieldValue, String iFieldName, Object iUserObject) {
    }

    public OUserObject2RecordHandler getObj2RecHandler() {
        return this.obj2RecHandler;
    }

    public OEntityManager getEntityManager() {
        return this.entityManager;
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    @Override
    public boolean fetchEmbeddedDocuments() {
        return true;
    }
}

