/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.fetch.json;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OFetchException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OJSONFetchContext
implements OFetchContext {
    protected final OJSONWriter jsonWriter;
    protected int indentLevel = 0;
    protected final boolean includeType;
    protected final boolean includeId;
    protected final boolean includeVer;
    protected final boolean includeClazz;
    protected final boolean attribSameRow;
    protected final boolean alwaysFetchEmbeddedDocuments;
    protected final boolean keepTypes;
    protected final Stack<StringBuilder> typesStack = new Stack();
    protected boolean insideCollection = false;
    protected int collectionDepthLevel = 0;

    public OJSONFetchContext(OJSONWriter iJsonWriter, boolean iIncludeType, boolean iIncludeId, boolean iIncludeVer, boolean iIncludeClazz, boolean iAttribSameRow, boolean iKeepTypes, boolean iAlwaysFetchEmbeddedDocuments) {
        this.jsonWriter = iJsonWriter;
        this.includeType = iIncludeType;
        this.includeClazz = iIncludeClazz;
        this.includeId = iIncludeId;
        this.includeVer = iIncludeVer;
        this.attribSameRow = iAttribSameRow;
        this.keepTypes = iKeepTypes;
        this.alwaysFetchEmbeddedDocuments = iAlwaysFetchEmbeddedDocuments;
    }

    @Override
    public void onBeforeFetch(ORecordSchemaAware<?> iRootRecord) {
        this.typesStack.add(new StringBuilder());
        if (this.insideCollection) {
            ++this.collectionDepthLevel;
        }
        this.insideCollection = false;
    }

    @Override
    public void onAfterFetch(ORecordSchemaAware<?> iRootRecord) {
        StringBuilder buffer = this.typesStack.pop();
        if (this.keepTypes && buffer.length() > 0) {
            try {
                this.jsonWriter.writeAttribute(this.indentLevel + 1, true, "@fieldTypes", buffer.toString());
            }
            catch (IOException e) {
                throw new OFetchException("Error writing field types", e);
            }
        }
        if (this.collectionDepthLevel > 0) {
            this.insideCollection = true;
            --this.collectionDepthLevel;
        }
    }

    @Override
    public void onBeforeStandardField(Object iFieldValue, String iFieldName, Object iUserObject) {
        if (this.keepTypes) {
            if (iFieldValue instanceof Long) {
                this.appendType(this.typesStack.peek(), iFieldName, 'l');
            } else if (iFieldValue instanceof Float) {
                this.appendType(this.typesStack.peek(), iFieldName, 'f');
            } else if (iFieldValue instanceof Short) {
                this.appendType(this.typesStack.peek(), iFieldName, 's');
            } else if (iFieldValue instanceof Double) {
                this.appendType(this.typesStack.peek(), iFieldName, 'd');
            } else if (iFieldValue instanceof Date) {
                this.appendType(this.typesStack.peek(), iFieldName, 't');
            } else if (iFieldValue instanceof Byte) {
                this.appendType(this.typesStack.peek(), iFieldName, 'b');
            }
        }
    }

    @Override
    public void onAfterStandardField(Object iFieldValue, String iFieldName, Object iUserObject) {
    }

    @Override
    public void onBeforeArray(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject, OIdentifiable[] iArray) {
        this.onBeforeCollection(iRootRecord, iFieldName, iUserObject, null);
    }

    @Override
    public void onAfterArray(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        this.onAfterCollection(iRootRecord, iFieldName, iUserObject);
    }

    @Override
    public void onBeforeCollection(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject, Collection<?> iCollection) {
        ++this.indentLevel;
        try {
            this.jsonWriter.beginCollection(this.indentLevel, true, iFieldName);
            this.insideCollection = true;
        }
        catch (IOException e) {
            throw new OFetchException("Error writing collection field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
    }

    @Override
    public void onAfterCollection(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        try {
            this.jsonWriter.endCollection(this.indentLevel, false);
            this.insideCollection = false;
        }
        catch (IOException e) {
            throw new OFetchException("Error writing collection field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
        --this.indentLevel;
    }

    @Override
    public void onBeforeMap(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        ++this.indentLevel;
        try {
            this.jsonWriter.beginObject(this.indentLevel, true, iFieldName);
        }
        catch (IOException e) {
            throw new OFetchException("Error writing map field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
    }

    @Override
    public void onAfterMap(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        try {
            this.jsonWriter.endObject(this.indentLevel, true);
        }
        catch (IOException e) {
            throw new OFetchException("Error writing map field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
        --this.indentLevel;
    }

    @Override
    public void onBeforeDocument(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        ++this.indentLevel;
        try {
            this.jsonWriter.beginObject(this.indentLevel, true, this.insideCollection ? null : iFieldName);
            this.writeSignature(this.jsonWriter, this.indentLevel, this.includeType, this.includeId, this.includeVer, this.includeClazz, this.attribSameRow, iRootRecord);
        }
        catch (IOException e) {
            throw new OFetchException("Error writing link field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
    }

    @Override
    public void onAfterDocument(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        try {
            this.jsonWriter.endObject(this.indentLevel + 1, true);
        }
        catch (IOException e) {
            throw new OFetchException("Error writing link field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
        --this.indentLevel;
    }

    public void writeLinkedValue(OIdentifiable iRecord, String iFieldName) throws IOException {
        if (this.insideCollection) {
            this.jsonWriter.writeValue(this.indentLevel, true, OJSONWriter.encode(iRecord.getIdentity()));
        } else {
            this.jsonWriter.writeAttribute(this.indentLevel, true, iFieldName, OJSONWriter.encode(iRecord.getIdentity()));
        }
    }

    public OJSONWriter getJsonWriter() {
        return this.jsonWriter;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    private void appendType(StringBuilder iBuffer, String iFieldName, char iType) {
        if (iBuffer.length() > 0) {
            iBuffer.append(',');
        }
        iBuffer.append(iFieldName);
        iBuffer.append('=');
        iBuffer.append(iType);
    }

    public void writeSignature(OJSONWriter json, int indentLevel, boolean includeType, boolean includeId, boolean includeVer, boolean includeClazz, boolean attribSameRow, ORecordInternal<?> record) throws IOException {
        boolean firstAttribute = true;
        if (includeType) {
            json.writeAttribute(firstAttribute ? indentLevel + 1 : 0, firstAttribute, "@type", "" + (char)record.getRecordType());
            if (attribSameRow) {
                firstAttribute = false;
            }
        }
        if (includeId && record.getIdentity() != null && record.getIdentity().isValid()) {
            json.writeAttribute(!firstAttribute ? indentLevel + 1 : 0, firstAttribute, "@rid", record.getIdentity().toString());
            if (attribSameRow) {
                firstAttribute = false;
            }
        }
        if (includeVer) {
            json.writeAttribute(firstAttribute ? indentLevel + 1 : 0, firstAttribute, "@version", record.getVersion());
            if (attribSameRow) {
                firstAttribute = false;
            }
        }
        if (includeClazz && record instanceof ORecordSchemaAware && ((ORecordSchemaAware)record).getClassName() != null) {
            json.writeAttribute(firstAttribute ? indentLevel + 1 : 0, firstAttribute, "@class", ((ORecordSchemaAware)record).getClassName());
            if (attribSameRow) {
                firstAttribute = false;
            }
        }
    }

    @Override
    public boolean fetchEmbeddedDocuments() {
        return this.alwaysFetchEmbeddedDocuments;
    }
}

