/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.entity;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OEntityManager {
    private static Map<String, OEntityManager> databaseInstances = new HashMap<String, OEntityManager>();
    private Map<String, Class<?>> entityClasses = new HashMap();

    protected OEntityManager() {
        OLogManager.instance().debug((Object)this, "Registering entity manager", new Object[0]);
        this.registerEntityClass(OUser.class);
        this.registerEntityClass(ORole.class);
    }

    public static synchronized OEntityManager getEntityManagerByDatabaseURL(String iURL) {
        OEntityManager instance = databaseInstances.get(iURL);
        if (instance == null) {
            instance = new OEntityManager();
            databaseInstances.put(iURL, instance);
        }
        return instance;
    }

    public Object createPojo(String iClassName) throws OConfigurationException {
        if (iClassName == null) {
            throw new IllegalArgumentException("Cannot create the object: class name is empty");
        }
        Class<?> entityClass = this.getEntityClass(iClassName);
        try {
            if (entityClass != null) {
                return this.createInstance(entityClass);
            }
        }
        catch (Exception e) {
            throw new OConfigurationException("Error while creating new pojo of class '" + iClassName + "'", e);
        }
        try {
            return this.createInstance(Class.forName(iClassName));
        }
        catch (Exception e) {
            throw new OConfigurationException("The class '" + iClassName + "' was not found between the entity classes. Ensure registerEntityClasses(package) has been called first.", e);
        }
    }

    protected Object createInstance(Class<?> iClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> c : iClass.getDeclaredConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            defaultConstructor = c;
            break;
        }
        if (defaultConstructor == null) {
            throw new IllegalArgumentException("Cannot create an object of class '" + iClass.getName() + "' because it has no default constructor. Please define the method: " + iClass.getSimpleName() + "()");
        }
        if (!defaultConstructor.isAccessible()) {
            defaultConstructor.setAccessible(true);
        }
        return defaultConstructor.newInstance(new Object[0]);
    }

    public Class<?> getEntityClass(String iClassName) {
        return this.entityClasses.get(iClassName);
    }

    public void registerEntityClass(Class<?> iClass) {
        this.entityClasses.put(iClass.getSimpleName(), iClass);
    }

    public void registerEntityClasses(String iPackageName) {
        this.registerEntityClasses(iPackageName, Thread.currentThread().getContextClassLoader());
    }

    public void registerEntityClasses(String iPackageName, ClassLoader iClassLoader) {
        OLogManager.instance().debug((Object)this, "Discovering entity classes inside package: %s", iPackageName);
        List<Class<?>> classes = null;
        try {
            classes = OReflectionHelper.getClassesForPackage(iPackageName, iClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new OException(e);
        }
        for (Class<?> clazz : classes) {
            String className = clazz.getSimpleName();
            this.entityClasses.put(className, clazz);
        }
        if (OLogManager.instance().isDebugEnabled()) {
            for (Map.Entry entry : this.entityClasses.entrySet()) {
                OLogManager.instance().debug((Object)this, "Loaded entity class '%s' from: %s", entry.getKey(), entry.getValue());
            }
        }
    }
}

