/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;

public class ODatabaseCompare
extends ODatabaseImpExpAbstract {
    private OStorage storage1;
    private OStorage storage2;
    private int differences = 0;

    public ODatabaseCompare(String iDb1URL, String iDb2URL, OCommandOutputListener iListener) throws IOException {
        super(null, null, iListener);
        this.listener.onMessage("\nComparing two local databases:\n1) " + iDb1URL + "\n2) " + iDb2URL + "\n");
        this.storage1 = Orient.instance().loadStorage(iDb1URL);
        this.storage1.open(null, null, null);
        this.storage2 = Orient.instance().loadStorage(iDb2URL);
        this.storage2.open(null, null, null);
    }

    public boolean compare() {
        block5: {
            this.compareClusters();
            this.compareRecords();
            if (this.differences != 0) break block5;
            this.listener.onMessage("\n\nDatabases match.");
            boolean bl = true;
            Object var3_4 = null;
            this.storage1.close();
            this.storage2.close();
            return bl;
        }
        try {
            this.listener.onMessage("\n\nDatabases do not match. Found " + this.differences + " difference(s).");
            boolean bl = false;
            Object var3_5 = null;
            this.storage1.close();
            this.storage2.close();
            return bl;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new ODatabaseExportException("Error on compare of database '" + this.storage1.getName() + "' against '" + this.storage2.getName() + "'", e);
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.storage1.close();
                this.storage2.close();
                throw throwable;
            }
        }
    }

    private boolean compareClusters() {
        this.listener.onMessage("\nStarting shallow comparison of clusters:");
        this.listener.onMessage("\nChecking the number of clusters...");
        if (this.storage1.getClusterNames().size() != this.storage1.getClusterNames().size()) {
            this.listener.onMessage("ERR: cluster sizes are different: " + this.storage1.getClusterNames().size() + " <-> " + this.storage1.getClusterNames().size());
            ++this.differences;
        }
        for (String clusterName : this.storage1.getClusterNames()) {
            if (this.includeClusters != null ? !this.includeClusters.contains(clusterName) : this.excludeClusters != null && this.excludeClusters.contains(clusterName)) continue;
            boolean ok = true;
            int cluster2Id = this.storage2.getClusterIdByName(clusterName);
            this.listener.onMessage("\n- Checking cluster " + String.format("%-25s: ", "'" + clusterName + "'"));
            if (cluster2Id == -1) {
                this.listener.onMessage("ERR: cluster name " + clusterName + " was not found on database " + this.storage2);
                ++this.differences;
                ok = false;
            }
            if (cluster2Id != this.storage1.getClusterIdByName(clusterName)) {
                this.listener.onMessage("ERR: cluster id is different for cluster " + clusterName + ": " + this.storage1.getClusterIdByName(clusterName) + " <-> " + cluster2Id);
                ++this.differences;
                ok = false;
            }
            if (this.storage1.count(cluster2Id) != this.storage2.count(cluster2Id)) {
                this.listener.onMessage("ERR: number of records different in cluster '" + clusterName + "' (id=" + cluster2Id + "): " + this.storage1.count(cluster2Id) + " <-> " + this.storage2.count(cluster2Id));
                ++this.differences;
                ok = false;
            }
            if (!ok) continue;
            this.listener.onMessage("OK");
        }
        this.listener.onMessage("\n\nShallow analysis done.");
        return true;
    }

    private boolean compareRecords() {
        this.listener.onMessage("\nStarting deep comparison record by record. This may take a few minutes. Wait please...");
        for (String clusterName : this.storage1.getClusterNames()) {
            if (this.includeClusters != null ? !this.includeClusters.contains(clusterName) : this.excludeClusters != null && this.excludeClusters.contains(clusterName)) continue;
            int clusterId = this.storage1.getClusterIdByName(clusterName);
            long db1Max = this.storage1.getClusterDataRange(clusterId)[1];
            long db2Max = this.storage2.getClusterDataRange(clusterId)[1];
            ODocument doc1 = new ODocument();
            ODocument doc2 = new ODocument();
            ORecordId rid = new ORecordId(clusterId);
            long clusterMax = Math.max(db1Max, db2Max);
            int i = 0;
            while ((long)i <= clusterMax) {
                block6: {
                    ORawBuffer buffer2;
                    ORawBuffer buffer1;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            rid.clusterPosition = i;
                                            buffer1 = (long)i <= db1Max ? this.storage1.readRecord(rid, null, null) : null;
                                            ORawBuffer oRawBuffer = buffer2 = (long)i <= db2Max ? this.storage2.readRecord(rid, null, null) : null;
                                            if (buffer1 == null && buffer2 == null) break block6;
                                            if (buffer1 != null || buffer2 == null) break block7;
                                            this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " is null in DB1");
                                            ++this.differences;
                                            break block6;
                                        }
                                        if (buffer1 == null || buffer2 != null) break block8;
                                        this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " is null in DB2");
                                        ++this.differences;
                                        break block6;
                                    }
                                    if (buffer1.recordType != buffer2.recordType) {
                                        this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " recordType is different: " + (char)buffer1.recordType + " <-> " + (char)buffer2.recordType);
                                        ++this.differences;
                                    }
                                    if (buffer1.buffer == null && buffer2.buffer == null) break block6;
                                    if (buffer1.buffer != null || buffer2.buffer == null) break block9;
                                    this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " content is different: null <-> " + buffer2.buffer.length);
                                    ++this.differences;
                                    break block6;
                                }
                                if (buffer1.buffer == null || buffer2.buffer != null) break block10;
                                this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " content is different: " + buffer1.buffer.length + " <-> null");
                                ++this.differences;
                                break block6;
                            }
                            if (buffer1.buffer.length == buffer2.buffer.length) break block11;
                            String rec1 = new String(buffer1.buffer).trim();
                            String rec2 = new String(buffer2.buffer).trim();
                            if (rec1.length() == rec2.length()) break block6;
                            this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " content length is different: " + buffer1.buffer.length + " <-> " + buffer2.buffer.length);
                            if (buffer1.recordType == 100 || buffer1.recordType == 102) {
                                this.listener.onMessage("\n--- REC1: " + rec1);
                            }
                            if (buffer2.recordType == 100 || buffer2.recordType == 102) {
                                this.listener.onMessage("\n--- REC2: " + rec2);
                            }
                            this.listener.onMessage("\n");
                            ++this.differences;
                            break block6;
                        }
                        if (buffer1.recordType != 100) break block12;
                        doc1.reset();
                        doc1.fromStream(buffer1.buffer);
                        doc2.reset();
                        doc2.fromStream(buffer2.buffer);
                        if (doc1.hasSameContentOf(doc2)) break block6;
                        this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " document content is different");
                        this.listener.onMessage("\n--- REC1: " + new String(buffer1.buffer));
                        this.listener.onMessage("\n--- REC2: " + new String(buffer2.buffer));
                        this.listener.onMessage("\n");
                        ++this.differences;
                        break block6;
                    }
                    for (int b = 0; b < buffer1.buffer.length; ++b) {
                        if (buffer1.buffer[b] == buffer2.buffer[b]) continue;
                        this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " content is different at byte #" + b + ": " + buffer1.buffer[b] + " <-> " + buffer2.buffer[b]);
                        this.listener.onMessage("\n--- REC1: " + new String(buffer1.buffer));
                        this.listener.onMessage("\n--- REC2: " + new String(buffer2.buffer));
                        this.listener.onMessage("\n");
                        ++this.differences;
                        break;
                    }
                }
                ++i;
            }
        }
        return true;
    }
}

