/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTrackedSet<T>
extends HashSet<T>
implements ORecordElement,
Serializable {
    protected final ORecord<?> sourceRecord;
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    protected static final Object ENTRY_REMOVAL = new Object();

    public OTrackedSet(ORecord<?> iRecord, Collection<? extends T> iOrigin) {
        this(iRecord);
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll(iOrigin);
        }
    }

    public OTrackedSet(ORecord<?> iSourceRecord) {
        this.sourceRecord = iSourceRecord;
    }

    @Override
    public boolean add(T e) {
        if (super.add(e)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.setDirty();
        super.clear();
    }

    public OTrackedSet<T> setDirty() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null && !this.sourceRecord.isDirty()) {
            this.sourceRecord.setDirty();
        }
        return this;
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }
}

