/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordTrackedIterator;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordTrackedSet
extends AbstractCollection<OIdentifiable>
implements Set<OIdentifiable>,
ORecordElement {
    protected final ORecord<?> sourceRecord;
    protected Map<Object, Object> map = new HashMap<Object, Object>();
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    protected static final Object ENTRY_REMOVAL = new Object();

    public ORecordTrackedSet(ORecord<?> iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        if (iSourceRecord != null) {
            iSourceRecord.setDirty();
        }
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new ORecordTrackedIterator(this.sourceRecord, this.map.keySet().iterator());
    }

    @Override
    public boolean add(OIdentifiable e) {
        if (this.map.containsKey(e)) {
            return false;
        }
        this.map.put(e, ENTRY_REMOVAL);
        this.setDirty();
        if (e instanceof ODocument) {
            ((ODocument)e).addOwner(this);
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        Object old = this.map.remove(o);
        if (old != null) {
            if (o instanceof ODocument) {
                ((ODocument)o).removeOwner(this);
            }
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.setDirty();
        this.map.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object item : c) {
            if (this.map.remove(item) == null) continue;
            changed = true;
        }
        if (changed) {
            this.setDirty();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        for (OIdentifiable oIdentifiable : c) {
            this.add(oIdentifiable);
        }
        this.setDirty();
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        if (super.removeAll(c)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public ORecordTrackedSet setDirty() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null && !this.sourceRecord.isDirty()) {
            this.sourceRecord.setDirty();
        }
        return this;
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
        this.map.remove(iRID);
        this.setDirty();
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
        this.map.put(iRecord, ENTRY_REMOVAL);
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }
}

