/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLazyRecordMultiIterator
implements OLazyIterator<OIdentifiable> {
    private final ORecord<?> sourceRecord;
    private final Object[] underlyingIterators;
    private final boolean convertToRecord;
    private int iteratorIndex = 0;

    public OLazyRecordMultiIterator(ORecord<?> iSourceRecord, Object[] iIterators, boolean iConvertToRecord) {
        this.sourceRecord = iSourceRecord;
        this.underlyingIterators = iIterators;
        this.convertToRecord = iConvertToRecord;
    }

    @Override
    public OIdentifiable next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Iterator<OIdentifiable> underlying = this.getCurrentIterator();
        ORecord<?> value = underlying.next();
        if (value == null) {
            return null;
        }
        if (value instanceof ORecordId && this.convertToRecord) {
            value = ((ORecordId)((Object)value)).getRecord();
            if (underlying instanceof OLazyIterator) {
                ((OLazyIterator)underlying).update(value);
            }
        }
        return value;
    }

    @Override
    public boolean hasNext() {
        Iterator<OIdentifiable> underlying = this.getCurrentIterator();
        boolean again = underlying.hasNext();
        while (!again && this.iteratorIndex < this.underlyingIterators.length - 1) {
            ++this.iteratorIndex;
            again = this.getCurrentIterator().hasNext();
        }
        return again;
    }

    @Override
    public OIdentifiable update(OIdentifiable iValue) {
        Iterator<OIdentifiable> underlying = this.getCurrentIterator();
        if (underlying instanceof OLazyIterator) {
            OIdentifiable old = ((OLazyIterator)underlying).update(iValue);
            if (this.sourceRecord != null && !old.equals(iValue)) {
                this.sourceRecord.setDirty();
            }
            return old;
        }
        throw new UnsupportedOperationException("Underlying iterator not supports lazy updates (Interface OLazyIterator");
    }

    @Override
    public void remove() {
        Iterator<OIdentifiable> underlying = this.getCurrentIterator();
        underlying.remove();
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    private Iterator<OIdentifiable> getCurrentIterator() {
        if (this.iteratorIndex > this.underlyingIterators.length) {
            throw new NoSuchElementException();
        }
        return (Iterator)this.underlyingIterators[this.iteratorIndex];
    }
}

