/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.object;

import com.orientechnologies.orient.core.db.ODatabasePoolAbstract;
import com.orientechnologies.orient.core.db.ODatabasePoolBase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectTx;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectTxPooled;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseObjectPool
extends ODatabasePoolBase<ODatabaseObjectTx> {
    private static ODatabaseObjectPool globalInstance = new ODatabaseObjectPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup(int iMinSize, int iMaxSize) {
        if (this.dbPool == null) {
            ODatabaseObjectPool oDatabaseObjectPool = this;
            synchronized (oDatabaseObjectPool) {
                if (this.dbPool == null) {
                    this.dbPool = new ODatabasePoolAbstract<ODatabaseObjectTx>((Object)this, iMinSize, iMaxSize){

                        @Override
                        public ODatabaseObjectTx createNewResource(String iDatabaseName, Object ... iAdditionalArgs) {
                            if (iAdditionalArgs.length < 2) {
                                throw new OSecurityAccessException("Username and/or password missing");
                            }
                            ODatabaseObjectTxPooled db = new ODatabaseObjectTxPooled((ODatabaseObjectPool)this.owner, iDatabaseName, (String)iAdditionalArgs[0], (String)iAdditionalArgs[1]);
                            ODatabaseRecordThreadLocal.INSTANCE.set(db.getUnderlying());
                            return db;
                        }

                        @Override
                        public boolean reuseResource(String iKey, Object[] iAdditionalArgs, ODatabaseObjectTx iValue) {
                            ODatabaseRecordThreadLocal.INSTANCE.set(iValue.getUnderlying());
                            ((ODatabaseObjectTxPooled)iValue).reuse(this.owner, iAdditionalArgs);
                            if (!iValue.getStorage().isClosed()) {
                                iValue.getMetadata().getSecurity().authenticate((String)iAdditionalArgs[0], (String)iAdditionalArgs[1]);
                                return true;
                            }
                            return false;
                        }
                    };
                }
            }
        }
    }

    public static ODatabaseObjectPool global() {
        return globalInstance;
    }
}

