/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.graph;

import com.orientechnologies.orient.core.annotation.OAfterDeserialization;
import com.orientechnologies.orient.core.db.graph.ODatabaseGraphTx;
import com.orientechnologies.orient.core.db.graph.OGraphElement;
import com.orientechnologies.orient.core.db.graph.OGraphVertex;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.lang.ref.SoftReference;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OGraphEdge
extends OGraphElement {
    private SoftReference<OGraphVertex> in;
    private SoftReference<OGraphVertex> out;

    public OGraphEdge(ODatabaseGraphTx iDatabase, ORID iRID) {
        super(iDatabase, iRID);
    }

    public OGraphEdge(ODatabaseGraphTx iDatabase) {
        super(iDatabase, "OGraphEdge");
    }

    public OGraphEdge(ODatabaseGraphTx iDatabase, String iClassName) {
        super(iDatabase, iClassName != null ? iClassName : "OGraphEdge");
    }

    public OGraphEdge(ODatabaseGraphTx iDatabase, String iClassName, OGraphVertex iOutNode, OGraphVertex iInNode) {
        this(iDatabase, iClassName);
        this.in = new SoftReference<OGraphVertex>(iInNode);
        this.out = new SoftReference<OGraphVertex>(iOutNode);
        this.set("in", iInNode.getDocument());
        this.set("out", iOutNode.getDocument());
    }

    public OGraphEdge(ODatabaseGraphTx iDatabase, OGraphVertex iOutNode, OGraphVertex iInNode) {
        this(iDatabase, "OGraphEdge", iOutNode, iInNode);
    }

    public OGraphEdge(ODatabaseGraphTx iDatabase, ODocument iDocument) {
        super(iDatabase, iDocument);
    }

    @Override
    @OAfterDeserialization
    public void fromStream(ODocument iDocument) {
        super.fromStream(iDocument);
        this.document.setTrackingChanges(false);
        this.out = null;
        this.in = null;
    }

    public OGraphVertex getIn() {
        if (this.in == null || this.in.get() == null) {
            this.in = new SoftReference<OGraphVertex>((OGraphVertex)this.database.getUserObjectByRecord((ODocument)this.document.field("in"), null));
        }
        return this.in.get();
    }

    public OGraphVertex getOut() {
        if (this.out == null || this.out.get() == null) {
            this.out = new SoftReference<OGraphVertex>((OGraphVertex)this.database.getUserObjectByRecord((ODocument)this.document.field("out"), null));
        }
        return this.out.get();
    }

    @Override
    public void reset() {
        this.document = null;
        this.in = null;
        this.out = null;
    }

    @Override
    public void delete() {
        OGraphEdge.delete(this.database, this.document);
        this.document = null;
        this.in = null;
        this.out = null;
    }

    @Override
    public void onEvent(ORecord<?> iDocument, ORecordListener.EVENT iEvent) {
        if (iEvent == ORecordListener.EVENT.UNLOAD) {
            this.out = null;
            this.in = null;
        }
    }

    public static void delete(ODatabaseGraphTx iDatabase, ODocument iEdge) {
        Set docs;
        OGraphVertex vertex;
        Set<OGraphEdge> edges;
        ODocument sourceVertex = (ODocument)iEdge.field("out");
        ODocument targetVertex = (ODocument)iEdge.field("in");
        if (sourceVertex != null && iDatabase.existsUserObjectByRID(sourceVertex.getIdentity()) && (edges = (vertex = (OGraphVertex)iDatabase.getUserObjectByRecord(sourceVertex, null)).getOutEdges()) != null) {
            for (OGraphEdge e : edges) {
                if (!e.getDocument().equals(iEdge)) continue;
                edges.remove(e);
                break;
            }
        }
        if (targetVertex != null && iDatabase.existsUserObjectByRID(targetVertex.getIdentity()) && (edges = (vertex = (OGraphVertex)iDatabase.getUserObjectByRecord(targetVertex, null)).getInEdges()) != null) {
            for (OGraphEdge e : edges) {
                if (!e.getDocument().equals(iEdge)) continue;
                edges.remove(e);
                break;
            }
        }
        if ((docs = (Set)sourceVertex.field("out")) != null) {
            docs.remove(iEdge);
        }
        sourceVertex.setDirty();
        sourceVertex.save();
        docs = (Set)targetVertex.field("in");
        if (docs != null) {
            docs.remove(iEdge);
        }
        targetVertex.setDirty();
        targetVertex.save();
        if (iDatabase.existsUserObjectByRID(iEdge.getIdentity())) {
            OGraphEdge edge = (OGraphEdge)iDatabase.getUserObjectByRecord(iEdge, null);
            iDatabase.unregisterPojo(edge, iEdge);
        }
        iEdge.delete();
    }

    protected void setIn(OGraphVertex iSource) {
        this.in = new SoftReference<OGraphVertex>(iSource);
        this.document.field("in", iSource.getDocument());
    }

    protected void setOut(OGraphVertex iDestination) {
        this.out = new SoftReference<OGraphVertex>(iDestination);
        this.document.field("out", iDestination.getDocument());
    }
}

