/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.graph;

import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.graph.OGraphDatabasePool;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;

public class OGraphDatabasePooled
extends OGraphDatabase
implements ODatabasePooled {
    private OGraphDatabasePool ownerPool;

    public OGraphDatabasePooled(OGraphDatabasePool iOwnerPool, String iURL, String iUserName, String iUserPassword) {
        super(iURL);
        this.ownerPool = iOwnerPool;
        super.open(iUserName, iUserPassword);
    }

    public void reuse(Object iOwner, Object[] iAdditionalArgs) {
        this.ownerPool = (OGraphDatabasePool)iOwner;
        if (this.isClosed()) {
            this.open((String)iAdditionalArgs[0], (String)iAdditionalArgs[1]);
        }
        this.getMetadata().reload();
        this.checkForGraphSchema();
    }

    public OGraphDatabasePooled open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Please use directly OGraphDatabase.open()");
    }

    public OGraphDatabasePooled create() {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot create the database in this way. Please use directly OGraphDatabase.create()");
    }

    public boolean isClosed() {
        return this.ownerPool == null || super.isClosed();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.vertexBaseClass = null;
        this.edgeBaseClass = null;
        this.checkOpeness();
        this.rollback();
        this.getMetadata().close();
        ((ODatabaseRaw)((ODatabaseRecordTx)this.underlying).getUnderlying()).callOnCloseListeners();
        this.getLevel1Cache().clear();
        this.ownerPool.release(this);
        this.ownerPool = null;
    }

    public void forceClose() {
        super.close();
    }

    protected void checkOpeness() {
        if (this.ownerPool == null) {
            throw new ODatabaseException("Database instance has been released to the pool. Get another database instance from the pool with the right username and password");
        }
        super.checkOpeness();
    }
}

