/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.graph;

import com.orientechnologies.orient.core.db.ODatabasePoolAbstract;
import com.orientechnologies.orient.core.db.ODatabasePoolBase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.graph.OGraphDatabasePooled;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OGraphDatabasePool
extends ODatabasePoolBase<OGraphDatabase> {
    private static OGraphDatabasePool globalInstance = new OGraphDatabasePool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup(int iMinSize, int iMaxSize) {
        if (this.dbPool == null) {
            OGraphDatabasePool oGraphDatabasePool = this;
            synchronized (oGraphDatabasePool) {
                if (this.dbPool == null) {
                    this.dbPool = new ODatabasePoolAbstract<OGraphDatabase>((Object)this, iMinSize, iMaxSize){

                        @Override
                        public OGraphDatabase createNewResource(String iDatabaseName, Object ... iAdditionalArgs) {
                            if (iAdditionalArgs.length < 2) {
                                throw new OSecurityAccessException("Username and/or password missing");
                            }
                            OGraphDatabasePooled db = new OGraphDatabasePooled((OGraphDatabasePool)this.owner, iDatabaseName, (String)iAdditionalArgs[0], (String)iAdditionalArgs[1]);
                            ODatabaseRecordThreadLocal.INSTANCE.set(db);
                            return db;
                        }

                        @Override
                        public boolean reuseResource(String iKey, Object[] iAdditionalArgs, OGraphDatabase iValue) {
                            ODatabaseRecordThreadLocal.INSTANCE.set(iValue);
                            ((OGraphDatabasePooled)iValue).reuse(this.owner, iAdditionalArgs);
                            if (!iValue.getStorage().isClosed()) {
                                iValue.getMetadata().getSecurity().authenticate((String)iAdditionalArgs[0], (String)iAdditionalArgs[1]);
                                return true;
                            }
                            return false;
                        }
                    };
                }
            }
        }
    }

    public static OGraphDatabasePool global() {
        globalInstance.setup();
        return globalInstance;
    }
}

