/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;

public class ODatabaseDocumentTxPooled
extends ODatabaseDocumentTx
implements ODatabasePooled {
    private ODatabaseDocumentPool ownerPool;

    public ODatabaseDocumentTxPooled(ODatabaseDocumentPool iOwnerPool, String iURL, String iUserName, String iUserPassword) {
        super(iURL);
        this.ownerPool = iOwnerPool;
        super.open(iUserName, iUserPassword);
    }

    public void reuse(Object iOwner, Object[] iAdditionalArgs) {
        this.ownerPool = (ODatabaseDocumentPool)iOwner;
        this.getMetadata().reload();
    }

    public ODatabaseDocumentTxPooled open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Please use directly ODatabaseDocumentTx.open()");
    }

    public ODatabaseDocumentTxPooled create() {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot create the database in this way. Please use directly ODatabaseDocumentTx.create()");
    }

    public boolean isClosed() {
        return this.ownerPool == null || super.isClosed();
    }

    public void close() {
        this.rollback();
        this.getLevel1Cache().clear();
        this.ownerPool.release(this);
        this.ownerPool = null;
    }

    public void forceClose() {
        super.close();
    }

    protected void checkOpeness() {
        if (this.ownerPool == null) {
            throw new ODatabaseException("Database instance has been released to the pool. Get another database instance from the pool with the right username and password");
        }
        super.checkOpeness();
    }
}

