/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.orient.core.db.ODatabasePoolAbstract;
import com.orientechnologies.orient.core.db.ODatabasePoolBase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTxPooled;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseDocumentPool
extends ODatabasePoolBase<ODatabaseDocumentTx> {
    private static ODatabaseDocumentPool globalInstance = new ODatabaseDocumentPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup(int iMinSize, int iMaxSize) {
        if (this.dbPool == null) {
            ODatabaseDocumentPool oDatabaseDocumentPool = this;
            synchronized (oDatabaseDocumentPool) {
                if (this.dbPool == null) {
                    this.dbPool = new ODatabasePoolAbstract<ODatabaseDocumentTx>((Object)this, iMinSize, iMaxSize){

                        @Override
                        public ODatabaseDocumentTx createNewResource(String iDatabaseName, Object ... iAdditionalArgs) {
                            if (iAdditionalArgs.length < 2) {
                                throw new OSecurityAccessException("Username and/or password missed");
                            }
                            ODatabaseDocumentTxPooled db = new ODatabaseDocumentTxPooled((ODatabaseDocumentPool)this.owner, iDatabaseName, (String)iAdditionalArgs[0], (String)iAdditionalArgs[1]);
                            ODatabaseRecordThreadLocal.INSTANCE.set(db);
                            return db;
                        }

                        @Override
                        public boolean reuseResource(String iKey, Object[] iAdditionalArgs, ODatabaseDocumentTx iValue) {
                            ODatabaseRecordThreadLocal.INSTANCE.set(iValue);
                            if (!((ODatabaseDocumentTxPooled)iValue).isClosed()) {
                                ((ODatabaseDocumentTxPooled)iValue).reuse(this.owner, iAdditionalArgs);
                                if (iValue.getStorage().isClosed()) {
                                    iValue.getStorage().open((String)iAdditionalArgs[0], (String)iAdditionalArgs[1], null);
                                } else if (!iValue.getUser().checkPassword((String)iAdditionalArgs[1])) {
                                    throw new OSecurityAccessException(iValue.getName(), "User or password not valid for database: '" + iValue.getName() + "'");
                                }
                                return true;
                            }
                            return false;
                        }
                    };
                }
            }
        }
    }

    public static ODatabaseDocumentPool global() {
        globalInstance.setup();
        return globalInstance;
    }
}

