/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import java.util.HashSet;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseFactory {
    final WeakHashMap<ODatabaseComplex<?>, Thread> instances = new WeakHashMap();

    public synchronized ODatabaseComplex<?> register(ODatabaseComplex<?> db) {
        this.instances.put(db, Thread.currentThread());
        return db;
    }

    public synchronized void unregister(ODatabaseComplex<?> db) {
        this.instances.remove(db);
    }

    public synchronized void shutdown() {
        if (this.instances.size() > 0) {
            OLogManager.instance().debug(null, "Found %d databases opened during OrientDB shutdown. Assure to always close database instances after usage", this.instances.size());
            for (ODatabaseComplex<?> db : new HashSet(this.instances.keySet())) {
                if (db == null || db.isClosed()) continue;
                db.close();
            }
        }
    }

    public ODatabaseDocumentTx createObjectDatabase(String url) {
        return new ODatabaseDocumentTx(url);
    }

    public OGraphDatabase createGraphDatabase(String url) {
        return new OGraphDatabase(url);
    }

    public ODatabaseDocumentTx createDocumentDatabase(String url) {
        return new ODatabaseDocumentTx(url);
    }
}

