/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandManager {
    private Map<String, Class<? extends OCommandRequest>> commandRequesters = new HashMap<String, Class<? extends OCommandRequest>>();
    private Map<Class<? extends OCommandRequest>, Class<? extends OCommandExecutor>> commandReqExecMap = new HashMap<Class<? extends OCommandRequest>, Class<? extends OCommandExecutor>>();
    private static OCommandManager instance = new OCommandManager();

    protected OCommandManager() {
        this.registerRequester("sql", OCommandSQL.class);
        this.registerExecutor(OSQLAsynchQuery.class, OCommandExecutorSQLDelegate.class);
        this.registerExecutor(OSQLSynchQuery.class, OCommandExecutorSQLDelegate.class);
        this.registerExecutor(OCommandSQL.class, OCommandExecutorSQLDelegate.class);
    }

    public OCommandManager registerRequester(String iType, Class<? extends OCommandRequest> iRequest) {
        this.commandRequesters.put(iType, iRequest);
        return this;
    }

    public boolean existsRequester(String iType) {
        return this.commandRequesters.containsKey(iType);
    }

    public OCommandRequest getRequester(String iType) {
        Class<? extends OCommandRequest> reqClass = this.commandRequesters.get(iType);
        if (reqClass == null) {
            throw new IllegalArgumentException("Cannot find a command requester for type: " + iType);
        }
        try {
            return reqClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create the command requester of class " + reqClass + " for type: " + iType, e);
        }
    }

    public OCommandManager registerExecutor(Class<? extends OCommandRequest> iRequest, Class<? extends OCommandExecutor> iExecutor) {
        this.commandReqExecMap.put(iRequest, iExecutor);
        return this;
    }

    public OCommandExecutor getExecutor(OCommandRequestInternal iCommand) {
        Class<? extends OCommandExecutor> executorClass = this.commandReqExecMap.get(iCommand.getClass());
        if (executorClass == null) {
            throw new IllegalArgumentException("Cannot find a command executor for the command request: " + iCommand);
        }
        try {
            return executorClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create the command executor of class " + executorClass + " for the command request: " + iCommand, e);
        }
    }

    public static OCommandManager instance() {
        return instance;
    }
}

