/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.cache.OAbstractRecordCache;
import com.orientechnologies.orient.core.cache.OCacheLocator;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLevel1RecordCache
extends OAbstractRecordCache {
    private OLevel2RecordCache secondary = null;
    private String CACHE_HIT;
    private String CACHE_MISS;

    public OLevel1RecordCache() {
        super(new OCacheLocator().primaryCache());
    }

    @Override
    public void startup() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
        this.secondary = db.getLevel2Cache();
        this.profilerPrefix = "db." + db.getName();
        this.CACHE_HIT = this.profilerPrefix + ".cache.found";
        this.CACHE_MISS = this.profilerPrefix + ".cache.notFound";
        this.excludedCluster = db.getClusterIdByName("index");
        super.startup();
        this.setEnable(OGlobalConfiguration.CACHE_LEVEL1_ENABLED.getValueAsBoolean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(ORecordInternal<?> record) {
        if (!this.isEnabled() || record.getIdentity().getClusterId() == this.excludedCluster || !record.getIdentity().isValid()) {
            return;
        }
        this.underlying.lock(record.getIdentity());
        try {
            if (this.underlying.get(record.getIdentity()) != record) {
                this.underlying.put(record);
            }
            Object var3_2 = null;
            this.underlying.unlock(record.getIdentity());
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.underlying.unlock(record.getIdentity());
            throw throwable;
        }
        this.secondary.updateRecord(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORecordInternal<?> findRecord(ORID rid) {
        ORecordInternal<?> record;
        if (!this.isEnabled()) {
            return null;
        }
        this.underlying.lock(rid);
        try {
            record = this.underlying.get(rid);
            if (record == null && (record = this.secondary.retrieveRecord(rid)) != null) {
                this.underlying.put(record);
            }
            Object var4_3 = null;
            this.underlying.unlock(rid);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.underlying.unlock(rid);
            throw throwable;
        }
        OProfiler.getInstance().updateCounter(record != null ? this.CACHE_HIT : this.CACHE_MISS, 1L);
        return record;
    }

    @Override
    public void deleteRecord(ORID rid) {
        super.deleteRecord(rid);
        this.secondary.freeRecord(rid);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.secondary = null;
    }

    @Override
    public void clear() {
        this.moveRecordsToSecondaryCache();
        super.clear();
    }

    private void moveRecordsToSecondaryCache() {
        if (this.secondary == null) {
            return;
        }
        for (ORID rid : this.underlying.keys()) {
            this.secondary.updateRecord(this.underlying.get(rid));
        }
    }

    public void invalidate() {
        this.underlying.clear();
    }

    public String toString() {
        return "DB level1 cache records = " + this.getSize() + ", maxSize= " + this.getMaxSize();
    }
}

