/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.cache.OCache;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OAbstractRecordCache
extends OSharedResourceAbstract {
    protected OCache underlying;
    protected String profilerPrefix = "noname";
    protected int excludedCluster = -1;

    public OAbstractRecordCache(OCache impl) {
        this.underlying = impl;
    }

    public boolean isEnabled() {
        return this.underlying.isEnabled();
    }

    public void setEnable(boolean enable) {
        if (enable) {
            this.underlying.enable();
        } else {
            this.underlying.disable();
        }
    }

    public ORecordInternal<?> freeRecord(ORID rid) {
        return this.underlying.remove(rid);
    }

    public void freeCluster(int cid) {
        HashSet<ORID> toRemove = new HashSet<ORID>(this.underlying.size() / 2);
        HashSet<ORID> keys = new HashSet<ORID>(this.underlying.keys());
        for (ORID id : keys) {
            if (id.getClusterId() != cid) continue;
            toRemove.add(id);
        }
        for (ORID ridToRemove : toRemove) {
            this.underlying.remove(ridToRemove);
        }
    }

    public void deleteRecord(ORID rid) {
        this.underlying.remove(rid);
    }

    public void clear() {
        this.underlying.clear();
    }

    public int getSize() {
        return this.underlying.size();
    }

    public int getMaxSize() {
        return this.underlying.limit();
    }

    public void startup() {
        this.underlying.startup();
        OProfiler.getInstance().registerHookValue(this.profilerPrefix + ".cache.enabled", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OAbstractRecordCache.this.isEnabled();
            }
        });
        OProfiler.getInstance().registerHookValue(this.profilerPrefix + ".cache.current", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OAbstractRecordCache.this.getSize();
            }
        });
        OProfiler.getInstance().registerHookValue(this.profilerPrefix + ".cache.max", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OAbstractRecordCache.this.getMaxSize();
            }
        });
    }

    public void shutdown() {
        this.underlying.shutdown();
    }
}

