/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.reflection;

import com.orientechnologies.common.log.OLogManager;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OReflectionHelper {
    private static final String CLASS_EXTENSION = ".class";

    public static List<Class<?>> getClassesForPackage(String iPackageName, ClassLoader iClassLoader) throws ClassNotFoundException {
        String className;
        ArrayList<File> directories;
        ArrayList classes;
        block13: {
            classes = new ArrayList();
            directories = new ArrayList<File>();
            try {
                String packageUrl = iPackageName.replace('.', '/');
                Enumeration<URL> resources = iClassLoader.getResources(packageUrl);
                if (!resources.hasMoreElements()) {
                    resources = iClassLoader.getResources(packageUrl + CLASS_EXTENSION);
                    if (resources.hasMoreElements()) {
                        throw new IllegalArgumentException(iPackageName + " does not appear to be a valid package but a class");
                    }
                    break block13;
                }
                while (resources.hasMoreElements()) {
                    URL res = resources.nextElement();
                    if (res.getProtocol().equalsIgnoreCase("jar")) {
                        JarURLConnection conn = (JarURLConnection)res.openConnection();
                        JarFile jar = conn.getJarFile();
                        for (JarEntry e : Collections.list(jar.entries())) {
                            if (!e.getName().startsWith(iPackageName.replace('.', '/')) || !e.getName().endsWith(CLASS_EXTENSION) || e.getName().contains("$")) continue;
                            className = e.getName().replace("/", ".").substring(0, e.getName().length() - 6);
                            classes.add(Class.forName(className));
                        }
                        continue;
                    }
                    directories.add(new File(URLDecoder.decode(res.getPath(), "UTF-8")));
                }
            }
            catch (NullPointerException x) {
                throw new ClassNotFoundException(iPackageName + " does not appear to be " + "a valid package (Null pointer exception)");
            }
            catch (UnsupportedEncodingException encex) {
                throw new ClassNotFoundException(iPackageName + " does not appear to be " + "a valid package (Unsupported encoding)");
            }
            catch (IOException ioex) {
                throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + iPackageName);
            }
        }
        for (File directory : directories) {
            if (directory.exists()) {
                File[] files;
                for (File file : files = directory.listFiles()) {
                    if (file.isDirectory()) {
                        classes.addAll(OReflectionHelper.findClasses(file, iPackageName));
                        continue;
                    }
                    if (!file.getName().endsWith(CLASS_EXTENSION)) continue;
                    className = file.getName().substring(0, file.getName().length() - CLASS_EXTENSION.length());
                    classes.add(Class.forName(iPackageName + '.' + className));
                }
                continue;
            }
            throw new ClassNotFoundException(iPackageName + " (" + directory.getPath() + ") does not appear to be a valid package");
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File iDirectory, String iPackageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!iDirectory.exists()) {
            return classes;
        }
        iPackageName = iPackageName + "." + iDirectory.getName();
        for (File file : files = iDirectory.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().contains(".")) continue;
                classes.addAll(OReflectionHelper.findClasses(file, iPackageName));
                continue;
            }
            if (!file.getName().endsWith(CLASS_EXTENSION)) continue;
            String className = file.getName().substring(0, file.getName().length() - CLASS_EXTENSION.length());
            classes.add(Class.forName(iPackageName + '.' + className));
        }
        return classes;
    }

    public static List<Class<?>> getClassessOfInterface(String thePackage, Class<?> theInterface, ClassLoader iClassLoader) {
        ArrayList classList = new ArrayList();
        try {
            for (Class<?> discovered : OReflectionHelper.getClassesForPackage(thePackage, iClassLoader)) {
                if (!Arrays.asList(discovered.getInterfaces()).contains(theInterface)) continue;
                classList.add(discovered);
            }
        }
        catch (ClassNotFoundException ex) {
            OLogManager.instance().error(null, "Error finding classes", (Throwable)ex, new Object[0]);
        }
        return classList;
    }
}

