/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class OLogFormatter
extends Formatter {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SSS");
    private static final String EOL = System.getProperty("line.separator");

    public String format(LogRecord record) {
        if (record.getThrown() == null) {
            return this.customFormatMessage(record);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(record.getMessage());
        for (Throwable current = record.getThrown(); current != null; current = current.getCause()) {
            buffer.append(EOL).append(current.getMessage());
            for (StackTraceElement stackTraceElement : record.getThrown().getStackTrace()) {
                buffer.append(EOL).append("-> ");
                buffer.append(stackTraceElement.toString());
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String customFormatMessage(LogRecord iRecord) {
        Level iLevel = iRecord.getLevel();
        String iMessage = iRecord.getMessage();
        Object[] iAdditionalArgs = iRecord.getParameters();
        String iRequester = this.getSourceClassSimpleName(iRecord.getSourceClassName());
        StringBuilder buffer = new StringBuilder();
        buffer.append(EOL);
        DateFormat dateFormat = OLogFormatter.dateFormat;
        synchronized (dateFormat) {
            buffer.append(OLogFormatter.dateFormat.format(new Date()));
        }
        buffer.append(' ');
        buffer.append(iLevel.getName().substring(0, 4));
        if (iRequester != null) {
            buffer.append(" [");
            buffer.append(iRequester);
            buffer.append(']');
        }
        buffer.append(' ');
        try {
            buffer.append(String.format(iMessage, iAdditionalArgs));
        }
        catch (Exception e) {
            buffer.append(iMessage);
        }
        return buffer.toString();
    }

    private String getSourceClassSimpleName(String iSourceClassName) {
        return iSourceClassName.substring(iSourceClassName.lastIndexOf(".") + 1);
    }
}

