/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.OTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class OSharedResourceTimeout {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected int timeout;

    public OSharedResourceTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected void acquireSharedLock() throws OTimeoutException {
        try {
            if (this.lock.readLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new OTimeoutException("Timeout on acquiring shared lock against resource: " + this);
    }

    protected void releaseSharedLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireExclusiveLock() throws OTimeoutException {
        try {
            if (this.lock.writeLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new OTimeoutException("Timeout on acquiring exclusive lock against resource: " + this);
    }

    protected void releaseExclusiveLock() {
        this.lock.writeLock().unlock();
    }
}

