/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OResourcePool<K, V> {
    private final Semaphore sem;
    private final Queue<V> resources = new ConcurrentLinkedQueue<V>();
    private final Collection<V> unmodifiableresources;
    private OResourcePoolListener<K, V> listener;

    public OResourcePool(int iMaxResources, OResourcePoolListener<K, V> iListener) {
        this.listener = iListener;
        this.sem = new Semaphore(iMaxResources + 1, true);
        this.unmodifiableresources = Collections.unmodifiableCollection(this.resources);
    }

    public V getResource(K iKey, long iMaxWaitMillis, Object ... iAdditionalArgs) throws OLockException {
        V res;
        try {
            if (!this.sem.tryAcquire(iMaxWaitMillis, TimeUnit.MILLISECONDS)) {
                throw new OLockException("Cannot acquire lock on requested resource: " + iKey);
            }
        }
        catch (InterruptedException e) {
            throw new OLockException("Cannot acquire lock on requested resource: " + iKey, e);
        }
        do {
            if ((res = this.resources.poll()) == null || !this.listener.reuseResource(iKey, iAdditionalArgs, res)) continue;
            return res;
        } while (!this.resources.isEmpty());
        try {
            res = this.listener.createNewResource(iKey, iAdditionalArgs);
            return res;
        }
        catch (Exception e) {
            this.sem.release();
            throw new OLockException("Error on creation of the new resource in the pool", e);
        }
    }

    public void returnResource(V res) {
        this.resources.add(res);
        this.sem.release();
    }

    public Collection<V> getResources() {
        return this.unmodifiableresources;
    }

    public void close() {
        this.sem.drainPermits();
    }
}

