/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OLockException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLockManager<RESOURCE_TYPE, REQUESTER_TYPE> {
    protected long acquireTimeout;
    protected HashMap<RESOURCE_TYPE, CountableLock> map = new HashMap();

    public OLockManager(int iAcquireTimeout) {
        this.acquireTimeout = iAcquireTimeout;
    }

    public void acquireLock(REQUESTER_TYPE iRequester, RESOURCE_TYPE iResourceId, LOCK iLockType) {
        this.acquireLock(iRequester, iResourceId, iLockType, this.acquireTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLock(REQUESTER_TYPE iRequester, RESOURCE_TYPE iResourceId, LOCK iLockType, long iTimeout) {
        block16: {
            CountableLock lock;
            HashMap<RESOURCE_TYPE, CountableLock> hashMap = this.map;
            synchronized (hashMap) {
                lock = this.map.get(iResourceId);
                if (lock == null) {
                    lock = new CountableLock(iTimeout > 0L);
                    this.map.put(this.getImmutableResourceId(iResourceId), lock);
                }
                ++lock.countLocks;
            }
            try {
                if (iTimeout <= 0L) {
                    if (iLockType == LOCK.SHARED) {
                        lock.readLock().lock();
                    } else {
                        lock.writeLock().lock();
                    }
                    break block16;
                }
                try {
                    if (iLockType == LOCK.SHARED ? !lock.readLock().tryLock(iTimeout, TimeUnit.MILLISECONDS) : !lock.writeLock().tryLock(iTimeout, TimeUnit.MILLISECONDS)) {
                        throw new OLockException("Timeout on acquiring resource '" + iResourceId + "' because is locked from another thread");
                    }
                }
                catch (InterruptedException e) {
                    throw new OLockException("Thread interrupted while waiting for resource '" + iResourceId + "'");
                }
            }
            catch (RuntimeException e) {
                HashMap<RESOURCE_TYPE, CountableLock> hashMap2 = this.map;
                synchronized (hashMap2) {
                    --lock.countLocks;
                    if (lock.countLocks == 0) {
                        this.map.remove(iResourceId);
                    }
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(REQUESTER_TYPE iRequester, RESOURCE_TYPE iResourceId, LOCK iLockType) throws OLockException {
        CountableLock lock;
        HashMap<RESOURCE_TYPE, CountableLock> hashMap = this.map;
        synchronized (hashMap) {
            lock = this.map.get(iResourceId);
            if (lock == null) {
                throw new OLockException("Error on releasing a non acquired lock by the requester '" + iRequester + "' against the resource: '" + iResourceId + "'");
            }
            --lock.countLocks;
            if (lock.countLocks == 0) {
                this.map.remove(iResourceId);
            }
        }
        if (iLockType == LOCK.SHARED) {
            lock.readLock().unlock();
        } else {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<RESOURCE_TYPE, CountableLock> hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
        }
    }

    public void setAcquireTimeout(long iAcquireTimeout) {
        this.acquireTimeout = iAcquireTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountCurrentLocks() {
        HashMap<RESOURCE_TYPE, CountableLock> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.size();
        }
    }

    protected RESOURCE_TYPE getImmutableResourceId(RESOURCE_TYPE iResourceId) {
        return iResourceId;
    }

    protected static class CountableLock
    extends ReentrantReadWriteLock {
        protected int countLocks = 0;

        public CountableLock(boolean iFair) {
            super(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LOCK {
        SHARED,
        EXCLUSIVE;

    }
}

