/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCompositeKey
implements Comparable<OCompositeKey>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Comparable> keys = new LinkedList<Comparable>();

    public OCompositeKey(List<? extends Comparable> keys) {
        this();
        for (Comparable comparable : keys) {
            this.addKey(comparable);
        }
    }

    public OCompositeKey(Comparable ... keys) {
        this();
        for (Comparable key : keys) {
            this.addKey(key);
        }
    }

    public OCompositeKey() {
    }

    public List<Comparable> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public void addKey(Comparable key) {
        if (key instanceof OCompositeKey) {
            OCompositeKey compositeKey = (OCompositeKey)key;
            for (Comparable inKey : compositeKey.keys) {
                this.addKey(inKey);
            }
        } else {
            this.keys.add(key);
        }
    }

    @Override
    public int compareTo(OCompositeKey otherKey) {
        Iterator<Comparable> inIter = this.keys.iterator();
        Iterator<Comparable> outIter = otherKey.keys.iterator();
        while (inIter.hasNext() && outIter.hasNext()) {
            Comparable outKey;
            Comparable inKey = inIter.next();
            int result = inKey.compareTo(outKey = outIter.next());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCompositeKey that = (OCompositeKey)o;
        return ((Object)this.keys).equals(that.keys);
    }

    public int hashCode() {
        return ((Object)this.keys).hashCode();
    }

    public String toString() {
        return "OCompositeKey{keys=" + this.keys + '}';
    }
}

