/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.stats;

import com.sleepycat.utilint.Latency;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.stats.NodeMetrics;
import oracle.kv.stats.OperationMetrics;

public class KVStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<OperationMetrics> opMetrics = new LinkedList<OperationMetrics>();
    private final List<NodeMetrics> nodeMetrics;
    private static Map<InternalOperation.OpCode, String> opCodeToNameMap = new HashMap<InternalOperation.OpCode, String>();

    public KVStats(boolean clear, RequestDispatcher requestDispatcher) {
        for (Map.Entry<InternalOperation.OpCode, Latency> entry : requestDispatcher.getLatencyStats(clear).entrySet()) {
            this.opMetrics.add(new OperationMetricsImpl(entry.getKey(), entry.getValue()));
        }
        this.nodeMetrics = new LinkedList<NodeMetrics>();
        Topology topology = requestDispatcher.getTopologyManager().getTopology();
        for (RepNodeState rns : requestDispatcher.getRepGroupStateTable().getRepNodeStates()) {
            this.nodeMetrics.add(new NodeMetricsImpl(topology, rns));
            if (!clear) continue;
            rns.resetStatsCounts();
        }
    }

    public List<OperationMetrics> getOpMetrics() {
        return this.opMetrics;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (OperationMetrics operationMetrics : this.getOpMetrics()) {
            if (operationMetrics.getTotalOps() <= 0) continue;
            sb.append(operationMetrics.toString()).append("\n");
        }
        for (NodeMetrics nodeMetrics : this.getNodeMetrics()) {
            sb.append(nodeMetrics.toString()).append("\n");
        }
        return sb.toString();
    }

    public List<NodeMetrics> getNodeMetrics() {
        return this.nodeMetrics;
    }

    private static String camelCase(String enumName) {
        StringBuffer sb = new StringBuffer(enumName.length());
        for (int i = 0; i < enumName.length(); ++i) {
            char nchar = enumName.charAt(i);
            if (nchar == '_') {
                if (i++ >= enumName.length()) break;
                nchar = Character.toUpperCase(enumName.charAt(i));
            } else {
                nchar = Character.toLowerCase(nchar);
            }
            sb.append(nchar);
        }
        return sb.toString();
    }

    static {
        for (InternalOperation.OpCode opCode : InternalOperation.OpCode.values()) {
            opCodeToNameMap.put(opCode, KVStats.camelCase(opCode.name()));
        }
    }

    private static class NodeMetricsImpl
    implements NodeMetrics {
        private static final long serialVersionUID = 1L;
        private final RepNodeId repNodeId;
        private final String datacenterName;
        private final boolean isActive;
        private final boolean isMaster;
        private final int maxActiveRequestCount;
        private final long accumRespTimeMs;
        private final long requestCount;

        private NodeMetricsImpl(Topology topology, RepNodeState rns) {
            this.repNodeId = rns.getRepNodeId();
            this.datacenterName = topology.getDatacenter(this.repNodeId).getName();
            this.isActive = !rns.reqHandlerNeedsResolution();
            this.isMaster = rns.getRepState().isMaster();
            this.maxActiveRequestCount = rns.getMaxActiveRequestCount();
            this.accumRespTimeMs = rns.getAccumRespTimeMs();
            this.requestCount = rns.getTotalRequestCount();
        }

        @Override
        public String getNodeName() {
            return this.repNodeId.toString();
        }

        @Override
        public String getDataCenterName() {
            return this.datacenterName;
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public boolean isMaster() {
            return this.isMaster;
        }

        @Override
        public int getMaxActiveRequestCount() {
            return this.maxActiveRequestCount;
        }

        @Override
        public long getRequestCount() {
            return this.requestCount;
        }

        @Override
        public int getAvLatencyMs() {
            return this.requestCount > 0L ? (int)(this.accumRespTimeMs / this.requestCount) : 0;
        }

        public String toString() {
            return String.format("%s (Datacenter %s): isActive= %b, isMaster= %b, maxActiveRequests= %,d, request count= %,d, avRespTime= %,d ms ", this.repNodeId.toString(), this.datacenterName, this.isActive, this.isMaster, this.maxActiveRequestCount, this.requestCount, this.getAvLatencyMs());
        }
    }

    private static class OperationMetricsImpl
    implements OperationMetrics,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String operationName;
        private final Latency latency;

        OperationMetricsImpl(InternalOperation.OpCode opCode, Latency latency) {
            this.operationName = (String)opCodeToNameMap.get((Object)opCode);
            this.latency = latency;
        }

        @Override
        public String getOperationName() {
            return this.operationName;
        }

        @Override
        public float getAverageLatencyMs() {
            return this.latency.getAvg();
        }

        @Override
        public int getMaxLatencyMs() {
            return this.latency.getMax();
        }

        @Override
        public int getMinLatencyMs() {
            return this.latency.getMin();
        }

        @Override
        public int getTotalOps() {
            return this.latency.getTotalOps();
        }

        public String toString() {
            return String.format("%s: total ops = %,d min/avg/max = %,d/%,.2f/%,d ms", this.operationName, this.getTotalOps(), this.getMinLatencyMs(), Float.valueOf(this.getAverageLatencyMs()), this.getMaxLatencyMs());
        }
    }
}

