/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class StorageNode
extends Topology.Component<StorageNodeId> {
    private static final long serialVersionUID = 1L;
    private DatacenterId datacenterId;
    private String hostname;
    private int registryPort;

    public StorageNode(Datacenter datacenter, String hostname, int registryPort) {
        this.datacenterId = (DatacenterId)datacenter.getResourceId();
        this.hostname = hostname;
        this.registryPort = registryPort;
    }

    private StorageNode(StorageNode storageNode) {
        super(storageNode);
        this.datacenterId = storageNode.datacenterId;
        this.hostname = storageNode.hostname;
        this.registryPort = storageNode.registryPort;
    }

    private StorageNode() {
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.STORAGE_NODE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.datacenterId == null ? 0 : this.datacenterId.hashCode());
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + this.registryPort;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.propertiesEquals((StorageNode)obj);
    }

    public boolean propertiesEquals(StorageNode other) {
        if (this.datacenterId == null ? other.datacenterId != null : !this.datacenterId.equals(other.datacenterId)) {
            return false;
        }
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        return this.registryPort == other.registryPort;
    }

    public DatacenterId getDatacenterId() {
        return this.datacenterId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    @Override
    public Topology.Component<?> clone() {
        return new StorageNode(this);
    }

    @Override
    public StorageNodeId getStorageNodeId() {
        return (StorageNodeId)this.getResourceId();
    }

    @Override
    public boolean isMonitorEnabled() {
        return true;
    }

    public String toString() {
        return "[" + this.getResourceId() + "] " + " dc=" + this.datacenterId + " " + this.hostname + ":" + this.registryPort;
    }
}

