/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class RepGroupId
extends ResourceId {
    private static final String REP_GROUP_PREFIX = "rg";
    private static final long serialVersionUID = 1L;
    private int groupId;

    public RepGroupId(int groupId) {
        this.groupId = groupId;
    }

    public RepGroupId(ObjectInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.groupId = in.readInt();
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.groupId);
    }

    private RepGroupId() {
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.REP_GROUP;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return REP_GROUP_PREFIX + this.getGroupId();
    }

    public boolean sameGroup(RepNodeId repNodeId) {
        return this.groupId == repNodeId.getGroupId();
    }

    public static RepGroupId parse(String groupName) {
        if (!groupName.startsWith(REP_GROUP_PREFIX)) {
            throw new IllegalArgumentException("Incorrect group prefix: " + groupName);
        }
        int groupNum = Integer.parseInt(groupName.substring(REP_GROUP_PREFIX.length()));
        return new RepGroupId(groupNum);
    }

    public String toString() {
        return this.getGroupName();
    }

    public RepGroup getComponent(Topology topology) {
        return topology.get(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepGroupId other = (RepGroupId)obj;
        return this.groupId == other.groupId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupId;
        return result;
    }
}

