/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class Datacenter
extends Topology.Component<DatacenterId> {
    private static final long serialVersionUID = 1L;
    private String name;

    public Datacenter(String name) {
        this.name = name;
    }

    private Datacenter(Datacenter datacenter) {
        super(datacenter);
        this.name = datacenter.name;
    }

    private Datacenter() {
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.DATACENTER;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Datacenter clone() {
        return new Datacenter(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Datacenter other = (Datacenter)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.getResourceId() + "] name=" + this.name);
        return sb.toString();
    }
}

