/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.admin;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.util.DbBackup;
import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.IllegalRepNodeServiceStateException;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminFaultHandler;
import oracle.kv.impl.rep.admin.RepNodeInfo;
import oracle.kv.impl.test.RemoteTestInterface;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;
import oracle.kv.impl.util.server.LoggerUtils;

public class RepNodeAdminImpl
extends VersionedRemoteImpl
implements RepNodeAdmin {
    private final RepNode repNode;
    private final RepNodeService repNodeService;
    private final CountDownLatch topoConfigLatch = new CountDownLatch(1);
    private final ProcessFaultHandler faultHandler;
    private final Logger logger;
    private DbBackup dbBackup;
    private RemoteTestInterface rti;
    private static final String TEST_INTERFACE_NAME = "oracle.kv.impl.rep.RepNodeTestInterface";

    public RepNodeAdminImpl(RepNodeService repNodeService, RepNode repNode) {
        this.repNodeService = repNodeService;
        this.repNode = repNode;
        this.rti = null;
        this.logger = LoggerUtils.getLogger(this.getClass(), (RepNodeService.Params)repNodeService.getParams());
        this.faultHandler = new RepNodeAdminFaultHandler(repNodeService, this.logger, ProcessExitCode.RESTART);
    }

    private void assertRunning() {
        ConfigurableService.ServiceStatus status = this.repNodeService.getStatusTracker().getServiceStatus();
        if (status != ConfigurableService.ServiceStatus.RUNNING) {
            throw new IllegalRepNodeServiceStateException("RepNode is not RUNNING, current status is " + (Object)((Object)status));
        }
    }

    private void startTestInterface() {
        try {
            Class<?> cl = Class.forName(TEST_INTERFACE_NAME);
            Constructor<?> c = cl.getConstructor(this.repNodeService.getClass());
            this.rti = (RemoteTestInterface)c.newInstance(this.repNodeService);
            this.rti.start((short)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void newParameters(short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.repNodeService.newParameters();
            }
        });
    }

    @Override
    public Topology getTopology(short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Topology>(){

            @Override
            public Topology execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getTopology() : null;
            }
        });
    }

    @Override
    public int getTopoSeqNum(short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                if (status != ConfigurableService.ServiceStatus.RUNNING) {
                    return 0;
                }
                Topology topology = RepNodeAdminImpl.this.repNode.getTopology();
                return topology != null ? topology.getSequenceNumber() : Topology.EMPTY_SEQUENCE_NUMBER;
            }
        });
    }

    @Override
    public LoadParameters getParams(short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<LoadParameters>(){

            @Override
            public LoadParameters execute() {
                RepNodeAdminImpl.this.assertRunning();
                return RepNodeAdminImpl.this.repNode.getAllParams();
            }
        });
    }

    @Override
    public void configure(final Topology topology, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.repNode.configure(topology);
                RepNodeAdminImpl.this.topoConfigLatch.countDown();
            }
        });
    }

    @Override
    public void updateTopology(final Topology newTopology, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.repNode.updateTopology(newTopology);
            }
        });
    }

    @Override
    public void updateTopology(final List<TopologyChange> changes, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.repNode.updateTopology(changes);
            }
        });
    }

    @Override
    public void shutdown(final boolean force, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.repNodeService.stop(force);
            }
        });
    }

    public void startup() throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                RepNodeAdminImpl.this.repNodeService.rebind((Remote)RepNodeAdminImpl.this, RegistryUtils.InterfaceType.ADMIN);
                RepNodeAdminImpl.this.logger.info("RepNodeAdmin registered");
                RepNodeAdminImpl.this.startTestInterface();
            }
        });
    }

    public void waitForConfigure() throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                if (RepNodeAdminImpl.this.repNode.getTopology() != null) {
                    return;
                }
                try {
                    RepNodeAdminImpl.this.logger.info("RepNodeAdmin waiting for initial topology");
                    RepNodeAdminImpl.this.repNodeService.getStatusTracker().update(ConfigurableService.ServiceStatus.WAITING_FOR_DEPLOY);
                    RepNodeAdminImpl.this.topoConfigLatch.await();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                RepNodeAdminImpl.this.logger.info("RepNodeAdmin starting");
            }
        });
    }

    public void stop() {
        try {
            this.repNodeService.unbind((Remote)this, RegistryUtils.InterfaceType.ADMIN);
            this.logger.info("RepNodeAdmin stopping");
            if (this.rti != null) {
                this.rti.stop((short)1);
            }
        }
        catch (RemoteException e) {
            this.logger.log(Level.INFO, "Ignoring exception while stopping repNodeAdmin", e);
            return;
        }
    }

    @Override
    public RepNodeStatus ping(short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeStatus>(){

            @Override
            public RepNodeStatus execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                ReplicatedEnvironment.State state = ReplicatedEnvironment.State.DETACHED;
                long currentVLSN = 0L;
                try {
                    ReplicatedEnvironment env = RepNodeAdminImpl.this.repNode.getEnv(1L);
                    if (env != null) {
                        currentVLSN = RepInternal.getRepImpl((ReplicatedEnvironment)env).getVLSNIndex().getRange().getLast().getSequence();
                        state = env.getState();
                    }
                }
                catch (EnvironmentFailureException ignored) {
                    // empty catch block
                }
                int haPort = RepNodeAdminImpl.this.repNode.getRepNodeParams().getHAPort();
                return new RepNodeStatus(status, state, currentVLSN, haPort);
            }
        });
    }

    @Override
    public RepNodeInfo getInfo(short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeInfo>(){

            @Override
            public RepNodeInfo execute() {
                RepNodeAdminImpl.this.assertRunning();
                return new RepNodeInfo(RepNodeAdminImpl.this.repNode);
            }
        });
    }

    @Override
    public String[] startBackup(short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<String[]>(){

            @Override
            public String[] execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.logger.info("Starting backup/snapshot");
                ReplicatedEnvironment env = RepNodeAdminImpl.this.repNode.getEnv(1L);
                if (RepNodeAdminImpl.this.dbBackup != null) {
                    RepNodeAdminImpl.this.dbBackup.endBackup();
                }
                RepNodeAdminImpl.this.dbBackup = new DbBackup((Environment)env);
                RepNodeAdminImpl.this.dbBackup.startBackup();
                return RepNodeAdminImpl.this.dbBackup.getLogFilesInBackupSet();
            }
        });
    }

    @Override
    public long stopBackup(short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Long>(){

            @Override
            public Long execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.logger.info("Ending backup/snapshot");
                long lastFile = -1L;
                if (RepNodeAdminImpl.this.dbBackup != null) {
                    lastFile = RepNodeAdminImpl.this.dbBackup.getLastFileInBackupSet();
                    RepNodeAdminImpl.this.dbBackup.endBackup();
                    RepNodeAdminImpl.this.dbBackup = null;
                }
                return lastFile;
            }
        });
    }

    @Override
    public void updateMemberHAAddress(final String groupName, final String targetNodeName, final String targetHelperHosts, final String newNodeHostPort, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.repNodeService.updateMemberHAAddress(groupName, targetNodeName, targetHelperHosts, newNodeHostPort);
            }
        });
    }
}

