/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.param;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LoadParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ParameterMap> maps = new ArrayList<ParameterMap>();
    private int version = 1;

    public static LoadParameters getParameters(File file) {
        LoadParameters lp = new LoadParameters();
        lp.load(file, false);
        return lp;
    }

    public static LoadParameters getParametersByType(File file) {
        LoadParameters lp = new LoadParameters();
        lp.load(file, true);
        return lp;
    }

    public void saveParameters(File file) {
        PrintWriter writer = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            writer = new PrintWriter(fos);
            writer.printf("<config version=\"%d\">\n", this.version);
            for (ParameterMap map : this.maps) {
                map.write(writer);
            }
            writer.printf("</config>\n", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem saving config file: " + file + ": " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public List<ParameterMap> getMaps() {
        return this.maps;
    }

    public void addMap(ParameterMap map) {
        this.maps.add(map);
    }

    public boolean removeMap(String name) {
        ParameterMap map = this.getMap(name);
        if (map != null) {
            return this.maps.remove(map);
        }
        return false;
    }

    public ParameterMap getMap(String name, String type) {
        for (ParameterMap map : this.maps) {
            if (!name.equals(map.getName()) || !type.equals(map.getType())) continue;
            return map;
        }
        return null;
    }

    public ParameterMap getMapByType(String type) {
        for (ParameterMap map : this.maps) {
            if (!type.equals(map.getType())) continue;
            return map;
        }
        return null;
    }

    public List<ParameterMap> getAllMaps(String type) {
        ArrayList<ParameterMap> list = new ArrayList<ParameterMap>();
        for (ParameterMap map : this.maps) {
            if (!type.equals(map.getType())) continue;
            list.add(map);
        }
        return list;
    }

    public ParameterMap getMap(String name) {
        for (ParameterMap map : this.maps) {
            if (!name.equals(map.getName())) continue;
            return map;
        }
        return null;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void load(File file, boolean useTypes) {
        InputStream is = null;
        try {
            URL url = file.toURI().toURL();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader xr = factory.newSAXParser().getXMLReader();
            ConfigHandler handler = new ConfigHandler(useTypes);
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            is = url.openStream();
            xr.parse(new InputSource(is));
        }
        catch (SAXParseException e) {
            String msg = "Error while parsing line " + e.getLineNumber() + " of " + file + ": " + e.getMessage();
            throw new IllegalStateException(msg);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Problem with XML: " + e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (MalformedURLException me) {
            throw new IllegalStateException("Could not translate file to URL: " + file);
        }
        catch (IOException io) {
            throw new IllegalStateException("IOException parsing file: " + file + ": " + io);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    class ConfigHandler
    extends DefaultHandler {
        Locator locator;
        StringBuilder curItem;
        ParameterMap curMap;
        boolean useTypes;

        public ConfigHandler(boolean useTypes) {
            this.useTypes = useTypes;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("config")) {
                String stringVersion = attributes.getValue("version");
                if (stringVersion == null) {
                    throw new SAXParseException("config element must specify version", this.locator);
                }
                LoadParameters.this.version = Integer.parseInt(stringVersion);
            } else if (qName.equals("component")) {
                String curComponent = attributes.getValue("name");
                String curType = attributes.getValue("type");
                this.curMap = new ParameterMap(curComponent, curType, LoadParameters.this.version);
                if (curComponent == null || curType == null) {
                    throw new SAXParseException("component element must specify name and type", this.locator);
                }
            } else if (qName.equals("property")) {
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                if (attributes.getLength() < 2 || attributes.getLength() > 3 || name == null || value == null) {
                    throw new SAXParseException("property element must only have 'name', 'value' and (optional) 'type' attributes", this.locator);
                }
                if (this.curMap == null) {
                    throw new SAXParseException("property elements are not allowed at global scope", this.locator);
                }
                if (this.curMap.exists(name)) {
                    throw new SAXParseException("Duplicate property: " + name, this.locator);
                }
                Parameter param = null;
                if (this.useTypes) {
                    String type = attributes.getValue("type");
                    if (type == null) {
                        throw new SAXParseException("type attribute required on property element in this path", this.locator);
                    }
                    param = Parameter.createKnownType((String)name, (String)value, (String)type);
                } else {
                    param = ParameterState.createParameter((String)name, (String)value);
                }
                this.curMap.put(param);
            } else {
                throw new SAXParseException("Unknown element '" + qName + "'", this.locator);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXParseException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXParseException {
            if (qName.equals("component")) {
                LoadParameters.this.maps.add(this.curMap);
                this.curMap = null;
            } else if (qName.equals("property")) {
                // empty if block
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

