/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyIterate;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.topo.PartitionId;

public class StoreIterate
extends MultiKeyIterate {
    public StoreIterate(byte[] parentKey, KeyRange subRange, Depth depth, Direction direction, int batchSize, byte[] resumeKey) {
        super(InternalOperation.OpCode.STORE_ITERATE, parentKey, subRange, depth, direction, batchSize, resumeKey);
    }

    StoreIterate(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.STORE_ITERATE, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        ArrayList<ResultKeyValueVersion> results = new ArrayList<ResultKeyValueVersion>();
        boolean moreElements = operationHandler.iterate(txn, partitionId, this.getParentKey(), false, this.getSubRange(), this.getDepth(), this.getDirection(), this.getBatchSize(), this.getResumeKey(), CursorConfig.READ_COMMITTED, results);
        return new Result.IterateResult(this.getOpCode(), results, moreElements);
    }
}

