/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.RequestValue;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.api.ops.SingleKeyOperation;
import oracle.kv.impl.topo.PartitionId;

public class Put
extends SingleKeyOperation {
    private final RequestValue requestValue;
    private final ReturnValueVersion.Choice prevValChoice;

    public Put(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice) {
        this(InternalOperation.OpCode.PUT, keyBytes, value, prevValChoice);
    }

    Put(InternalOperation.OpCode opCode, byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice) {
        super(opCode, keyBytes);
        this.requestValue = new RequestValue(value);
        this.prevValChoice = prevValChoice;
    }

    Put(ObjectInput in, short serialVersion) throws IOException {
        this(InternalOperation.OpCode.PUT, in, serialVersion);
    }

    Put(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.requestValue = new RequestValue(in, serialVersion);
        assert (this.requestValue.getBytes() != null);
        this.prevValChoice = ReturnValueVersion.getChoice(in.readUnsignedByte());
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.requestValue.writeFastExternal(out, serialVersion);
        out.writeByte(this.prevValChoice.ordinal());
    }

    public byte[] getValueBytes() {
        return this.requestValue.getBytes();
    }

    public ReturnValueVersion.Choice getReturnValueVersionChoice() {
        return this.prevValChoice;
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        ReturnResultValueVersion prevVal = new ReturnResultValueVersion(this.prevValChoice);
        Version newVersion = operationHandler.put(txn, partitionId, this.getKeyBytes(), this.getValueBytes(), prevVal);
        return new Result.PutResult(this.getOpCode(), prevVal.getValueVersion(), newVersion);
    }

    @Override
    public String toString() {
        return super.toString() + " Value: " + this.requestValue;
    }
}

