/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;

abstract class MultiKeyIterate
extends MultiKeyOperation {
    private final Direction direction;
    private final int batchSize;
    private final byte[] resumeKey;

    MultiKeyIterate(InternalOperation.OpCode opCode, byte[] parentKey, KeyRange subRange, Depth depth, Direction direction, int batchSize, byte[] resumeKey) {
        super(opCode, parentKey, subRange, depth);
        this.direction = direction;
        this.batchSize = batchSize;
        this.resumeKey = resumeKey;
    }

    MultiKeyIterate(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.direction = Direction.getDirection(in.readUnsignedByte());
        this.batchSize = in.readInt();
        short keyLen = in.readShort();
        if (keyLen < 0) {
            this.resumeKey = null;
        } else {
            this.resumeKey = new byte[keyLen];
            in.readFully(this.resumeKey);
        }
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeByte(this.direction.ordinal());
        out.writeInt(this.batchSize);
        if (this.resumeKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.resumeKey.length);
            out.write(this.resumeKey);
        }
    }

    Direction getDirection() {
        return this.direction;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }
}

