/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.ReturnValueVersion;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.api.ops.SingleKeyOperation;
import oracle.kv.impl.topo.PartitionId;

public class Delete
extends SingleKeyOperation {
    private final ReturnValueVersion.Choice prevValChoice;

    public Delete(byte[] keyBytes, ReturnValueVersion.Choice prevValChoice) {
        this(InternalOperation.OpCode.DELETE, keyBytes, prevValChoice);
    }

    Delete(InternalOperation.OpCode opCode, byte[] keyBytes, ReturnValueVersion.Choice prevValChoice) {
        super(opCode, keyBytes);
        this.prevValChoice = prevValChoice;
    }

    Delete(ObjectInput in, short serialVersion) throws IOException {
        this(InternalOperation.OpCode.DELETE, in, serialVersion);
    }

    Delete(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.prevValChoice = ReturnValueVersion.getChoice(in.readUnsignedByte());
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeByte(this.prevValChoice.ordinal());
    }

    public ReturnValueVersion.Choice getReturnValueVersionChoice() {
        return this.prevValChoice;
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        ReturnResultValueVersion prevVal = new ReturnResultValueVersion(this.prevValChoice);
        boolean result = operationHandler.delete(txn, partitionId, this.getKeyBytes(), prevVal);
        return new Result.DeleteResult(this.getOpCode(), prevVal.getValueVersion(), result);
    }

    @Override
    public String toString() {
        return "Delete " + super.toString();
    }
}

