/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;

public class TopologyManager {
    private final String kvsName;
    private Topology topology;
    private final List<Listener> listeners = new LinkedList<Listener>();
    private final Logger logger;

    public TopologyManager(String kvsName, Logger logger) {
        this.kvsName = kvsName;
        this.logger = logger;
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void invokeListeners() {
        for (Listener l : this.listeners) {
            l.update(this.topology);
        }
    }

    public Topology getTopology() {
        return this.topology;
    }

    public synchronized boolean update(Topology newTopology) {
        int prevSequenceNumber;
        if (this.topology != null && !this.kvsName.equals(this.topology.getKVStoreName())) {
            throw new IllegalArgumentException("Update topology associated with KVStore: " + this.topology.getKVStoreName() + " expected: " + this.kvsName);
        }
        int newSequenceNumber = newTopology.getSequenceNumber();
        int n = prevSequenceNumber = this.topology == null ? 0 : this.topology.getSequenceNumber();
        if (prevSequenceNumber >= newSequenceNumber) {
            this.logger.info("Topology update skipped.  Already have latest topology seq #: " + newSequenceNumber);
            return false;
        }
        this.logger.info("Topology updated from seq#: " + prevSequenceNumber + " to " + newSequenceNumber);
        this.topology = newTopology;
        this.invokeListeners();
        return true;
    }

    public synchronized boolean update(List<TopologyChange> changes) {
        Topology workingCopy = this.topology == null ? new Topology(this.kvsName) : this.topology.getCopy();
        int prevSequenceNumber = workingCopy.getSequenceNumber();
        boolean changed = workingCopy.apply(changes);
        if (changed) {
            this.topology = workingCopy;
            this.logger.info("Topology incrementally updated from seq#: " + prevSequenceNumber + " to " + this.topology.getSequenceNumber());
            this.invokeListeners();
        }
        return changed;
    }

    public static interface Listener {
        public void update(Topology var1);
    }
}

