/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.FaultException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.NOP;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;

public class Request
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private short serialVersion;
    private InternalOperation op;
    private PartitionId partitionId;
    private boolean write;
    private Durability durability;
    private Consistency consistency;
    private int topoSeqNumber;
    private ResourceId initialDispatcherId;
    private int ttl;
    private byte[] forwardingRNs = new byte[0];
    private int timeoutMs;

    public Request(InternalOperation op, PartitionId partitionId, boolean write, Durability durability, Consistency consistency, int ttl, int topoSeqNumber, ResourceId dispatcherId, int timeoutMs) {
        assert (op != null);
        assert (durability != null != (consistency != null));
        assert (write == (durability != null));
        this.serialVersion = (short)-1;
        this.op = op;
        this.partitionId = partitionId;
        this.write = write;
        this.durability = durability;
        this.consistency = consistency;
        this.ttl = ttl;
        this.topoSeqNumber = topoSeqNumber;
        this.initialDispatcherId = dispatcherId;
        this.timeoutMs = timeoutMs;
    }

    public static Request createNOP(int topoSeqNumber, ResourceId dispatcherId, int timeoutMs) {
        return new Request(new NOP(), PartitionId.NULL_ID, false, null, Consistency.NONE_REQUIRED, 1, topoSeqNumber, dispatcherId, timeoutMs);
    }

    public Request() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.serialVersion = in.readShort();
        this.partitionId = new PartitionId(in.readInt());
        boolean bl = this.write = in.readByte() != 0;
        if (this.write) {
            this.durability = new Durability(in, this.serialVersion);
            this.consistency = null;
        } else {
            this.durability = null;
            this.consistency = Consistency.readFastExternal(in, this.serialVersion);
        }
        this.ttl = in.readInt();
        int asize = in.readByte();
        this.forwardingRNs = new byte[asize];
        for (int i = 0; i < asize; ++i) {
            this.forwardingRNs[i] = in.readByte();
        }
        this.timeoutMs = in.readInt();
        this.topoSeqNumber = in.readInt();
        this.initialDispatcherId = ResourceId.readFastExternal(in, this.serialVersion);
        this.op = InternalOperation.readFastExternal(in, this.serialVersion);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (this.serialVersion != -1);
        out.writeShort(this.serialVersion);
        out.writeInt(this.partitionId.getPartitionId());
        out.writeByte(this.write ? 1 : 0);
        if (this.write) {
            this.durability.writeFastExternal(out, this.serialVersion);
        } else {
            this.consistency.writeFastExternal(out, this.serialVersion);
        }
        out.writeInt(this.ttl);
        out.writeByte(this.forwardingRNs.length);
        for (byte forwardingRN : this.forwardingRNs) {
            out.writeByte(forwardingRN);
        }
        out.writeInt(this.timeoutMs);
        out.writeInt(this.topoSeqNumber);
        this.initialDispatcherId.writeFastExternal(out, this.serialVersion);
        this.op.writeFastExternal(out, this.serialVersion);
    }

    public InternalOperation getOperation() {
        return this.op;
    }

    public boolean needsMaster() {
        return this.isWrite() || this.getConsistency() == Consistency.ABSOLUTE;
    }

    public boolean isWrite() {
        return this.write;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public void setSerialVersion(short serialVersion) {
        this.serialVersion = serialVersion;
    }

    short getSerialVersion() {
        return this.serialVersion;
    }

    public PartitionId getPartitionId() {
        return this.partitionId;
    }

    public int getTopoSeqNumber() {
        return this.topoSeqNumber;
    }

    public void setTopoSeqNumber(int topoSeqNumber) {
        this.topoSeqNumber = topoSeqNumber;
    }

    public ResourceId getInitialDispatcherId() {
        return this.initialDispatcherId;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void decTTL() throws FaultException {
        if (this.ttl-- == 0) {
            throw new OperationFaultException("TTL exceeded for request: " + this.getOperation() + " request dispatched by: " + this.getInitialDispatcherId());
        }
    }

    public int getTimeout() {
        return this.timeoutMs;
    }

    public void setTimeout(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public String toString() {
        return this.op.toString();
    }

    public void clearForwardingRNs() {
        this.forwardingRNs = new byte[0];
    }

    public Set<RepNodeId> getForwardingRNs(int repGroupId) {
        HashSet<RepNodeId> forwardingRNIds = new HashSet<RepNodeId>();
        for (byte nodeNum : this.forwardingRNs) {
            forwardingRNIds.add(new RepNodeId(repGroupId, (int)nodeNum));
        }
        return forwardingRNIds;
    }

    public void updateForwardingRNs(ResourceId currentDispatcherId, int groupId) {
        if (!currentDispatcherId.getType().isRepNode()) {
            return;
        }
        assert (currentDispatcherId.getType().isRepNode());
        RepNodeId repNodeId = (RepNodeId)currentDispatcherId;
        if (repNodeId.getGroupId() == groupId) {
            byte[] updateList = new byte[this.forwardingRNs.length + 1];
            System.arraycopy(this.forwardingRNs, 0, updateList, 0, this.forwardingRNs.length);
            assert (repNodeId.getNodeNum() < 128);
            updateList[this.forwardingRNs.length] = (byte)repNodeId.getNodeNum();
            this.forwardingRNs = updateList;
        } else {
            this.forwardingRNs = new byte[0];
        }
    }

    public boolean isInitiatingDispatcher(ResourceId resourceId) {
        return this.initialDispatcherId.equals(resourceId);
    }
}

