/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop;

import java.io.IOException;
import java.util.Iterator;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.KeyValueVersion;
import oracle.kv.hadoop.KVInputSplit;
import oracle.kv.impl.api.KVStoreImpl;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class KVRecordReader
extends RecordReader<Text, Text> {
    KVStore kvstore;
    Iterator<KeyValueVersion> iter;
    KeyValueVersion current;
    long cnt = 0L;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        KVInputSplit kvInputSplit = (KVInputSplit)split;
        String kvStoreName = kvInputSplit.getKVStoreName();
        String[] kvHelperHosts = kvInputSplit.getKVHelperHosts();
        this.kvstore = KVStoreFactory.getStore(new KVStoreConfig(kvStoreName, kvHelperHosts));
        KVStoreImpl kvstoreImpl = (KVStoreImpl)this.kvstore;
        int singlePartId = kvInputSplit.getKVPart();
        this.iter = kvstoreImpl.partitionIterator(kvInputSplit.getDirection(), kvInputSplit.getBatchSize(), singlePartId, kvInputSplit.getParentKey(), kvInputSplit.getSubRange(), kvInputSplit.getDepth(), kvInputSplit.getConsistency(), kvInputSplit.getTimeout(), kvInputSplit.getTimeoutUnit());
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        try {
            boolean ret = this.iter.hasNext();
            this.current = ret ? this.iter.next() : null;
            return ret;
        }
        catch (Exception E) {
            System.out.println("KVRecordReader " + (Object)((Object)this) + " caught: " + E);
            E.printStackTrace();
            return false;
        }
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        if (this.current == null) {
            return null;
        }
        return new Text(this.current.getKey().toString());
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        if (this.current == null) {
            return null;
        }
        return new Text(new String(this.current.getValue().getValue()));
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
        this.kvstore.close();
    }
}

