/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class KVInputSplit
extends InputSplit
implements Writable {
    private String kvStore;
    private String[] kvHelperHosts;
    private int kvPart;
    private Direction direction;
    private int batchSize;
    private Key parentKey;
    private KeyRange subRange;
    private Depth depth;
    private Consistency consistency;
    private long timeout;
    private TimeUnit timeoutUnit;
    private String[] locations = new String[0];

    public long getLength() throws IOException, InterruptedException {
        return 1L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return this.locations;
    }

    KVInputSplit setLocations(String[] locations) {
        this.locations = locations;
        return this;
    }

    KVInputSplit setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    Direction getDirection() {
        return this.direction;
    }

    KVInputSplit setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    KVInputSplit setParentKey(Key parentKey) {
        this.parentKey = parentKey;
        return this;
    }

    Key getParentKey() {
        return this.parentKey;
    }

    KVInputSplit setSubRange(KeyRange subRange) {
        this.subRange = subRange;
        return this;
    }

    KeyRange getSubRange() {
        return this.subRange;
    }

    KVInputSplit setDepth(Depth depth) {
        this.depth = depth;
        return this;
    }

    Depth getDepth() {
        return this.depth;
    }

    KVInputSplit setConsistency(Consistency consistency) {
        this.consistency = consistency;
        return this;
    }

    Consistency getConsistency() {
        return this.consistency;
    }

    KVInputSplit setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    long getTimeout() {
        return this.timeout;
    }

    KVInputSplit setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    KVInputSplit setKVHelperHosts(String[] kvHelperHosts) {
        this.kvHelperHosts = kvHelperHosts;
        return this;
    }

    String[] getKVHelperHosts() {
        return this.kvHelperHosts;
    }

    KVInputSplit setKVStoreName(String kvStore) {
        this.kvStore = kvStore;
        return this;
    }

    String getKVStoreName() {
        return this.kvStore;
    }

    KVInputSplit setKVPart(int kvPart) {
        this.kvPart = kvPart;
        return this;
    }

    int getKVPart() {
        return this.kvPart;
    }

    public void write(DataOutput out) throws IOException {
        int i;
        out.writeInt(this.kvHelperHosts.length);
        for (i = 0; i < this.kvHelperHosts.length; ++i) {
            Text.writeString((DataOutput)out, (String)this.kvHelperHosts[i]);
        }
        Text.writeString((DataOutput)out, (String)this.kvStore);
        Text.writeString((DataOutput)out, (String)("" + this.kvPart));
        Text.writeString((DataOutput)out, (String)(this.direction == null ? "" : this.direction.name()));
        out.writeInt(this.batchSize);
        this.writeBytes(out, this.parentKey == null ? null : this.parentKey.toByteArray());
        this.writeBytes(out, this.subRange == null ? null : this.subRange.toByteArray());
        Text.writeString((DataOutput)out, (String)(this.depth == null ? "" : this.depth.name()));
        this.writeBytes(out, this.consistency == null ? null : this.consistency.toByteArray());
        out.writeLong(this.timeout);
        Text.writeString((DataOutput)out, (String)(this.timeoutUnit == null ? "" : this.timeoutUnit.name()));
        out.writeInt(this.locations.length);
        for (i = 0; i < this.locations.length; ++i) {
            Text.writeString((DataOutput)out, (String)this.locations[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int nHelperHosts = in.readInt();
        this.kvHelperHosts = new String[nHelperHosts];
        for (int i = 0; i < nHelperHosts; ++i) {
            this.kvHelperHosts[i] = Text.readString((DataInput)in);
        }
        this.kvStore = Text.readString((DataInput)in);
        this.kvPart = Integer.parseInt(Text.readString((DataInput)in));
        String dirStr = Text.readString((DataInput)in);
        this.direction = dirStr == null || dirStr.equals("") ? Direction.FORWARD : Direction.valueOf(dirStr);
        this.batchSize = in.readInt();
        byte[] pkBytes = this.readBytes(in);
        this.parentKey = pkBytes == null ? null : Key.fromByteArray(pkBytes);
        byte[] srBytes = this.readBytes(in);
        this.subRange = srBytes == null ? null : KeyRange.fromByteArray(srBytes);
        String depthStr = Text.readString((DataInput)in);
        this.depth = depthStr == null || depthStr.equals("") ? Depth.PARENT_AND_DESCENDANTS : Depth.valueOf(depthStr);
        byte[] consBytes = this.readBytes(in);
        this.consistency = consBytes == null ? null : Consistency.fromByteArray(consBytes);
        this.timeout = in.readLong();
        String tuStr = Text.readString((DataInput)in);
        this.timeoutUnit = tuStr == null || tuStr.equals("") ? null : TimeUnit.valueOf(tuStr);
        int len = in.readInt();
        this.locations = new String[len];
        for (int i = 0; i < len; ++i) {
            this.locations[i] = Text.readString((DataInput)in);
        }
    }

    private void writeBytes(DataOutput out, byte[] bytes) throws IOException {
        if (bytes == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private byte[] readBytes(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            return null;
        }
        byte[] ret = new byte[len];
        in.readFully(ret);
        return ret;
    }
}

