/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KVStoreException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.hadoop.KVInputSplit;
import oracle.kv.hadoop.KVRecordReader;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.PartitionMap;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.registry.RegistryUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class KVInputFormat
extends InputFormat<Text, Text> {
    private static String kvStoreName;
    private static String[] kvHelperHosts;
    private static Direction direction;
    private static int batchSize;
    private static Key parentKey;
    private static KeyRange subRange;
    private static Depth depth;
    private static Consistency consistency;
    private static long timeout;
    private static TimeUnit timeoutUnit;

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Topology topology = null;
        try {
            topology = TopologyLocator.get(kvHelperHosts, 0);
        }
        catch (KVStoreException KVSE) {
            KVSE.printStackTrace();
            return null;
        }
        RegistryUtils regUtils = new RegistryUtils(topology);
        PartitionMap partitionMap = topology.getPartitionMap();
        int nParts = partitionMap.getNPartitions();
        ArrayList<InputSplit> ret = new ArrayList<InputSplit>(nParts);
        for (int i = 1; i <= nParts; ++i) {
            PartitionId partId = new PartitionId(i);
            RepGroupId repGroupId = topology.getRepGroupId(partId);
            RepGroup repGroup = topology.get(repGroupId);
            Collection<RepNode> repNodes = repGroup.getRepNodes();
            ArrayList<String> repNodeNames = new ArrayList<String>();
            ArrayList<String> repNodeNamesAndPorts = new ArrayList<String>();
            for (RepNode rn : repNodes) {
                ReplicatedEnvironment.State state;
                RepNodeStatus rnStatus = null;
                try {
                    RepNodeAdminAPI rna = regUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                    rnStatus = rna.ping();
                }
                catch (RemoteException re) {
                    System.err.println("Ping failed for " + rn.getResourceId() + ": " + re.getMessage());
                    re.printStackTrace();
                }
                catch (NotBoundException e) {
                    System.err.println("No RMI service for RN: " + rn.getResourceId() + " message: " + e.getMessage());
                }
                if (rnStatus == null || !(state = rnStatus.getReplicationState()).isActive() || consistency == Consistency.ABSOLUTE && !state.isMaster()) continue;
                StorageNodeId snid = rn.getStorageNodeId();
                StorageNode sn = topology.get(snid);
                repNodeNames.add(sn.getHostname());
                repNodeNamesAndPorts.add(sn.getHostname() + ":" + sn.getRegistryPort());
            }
            ret.add(new KVInputSplit().setKVHelperHosts(repNodeNamesAndPorts.toArray(new String[0])).setKVStoreName(kvStoreName).setKVPart(i).setLocations(repNodeNames.toArray(new String[0])).setDirection(direction).setBatchSize(batchSize).setParentKey(parentKey).setSubRange(subRange).setDepth(depth).setConsistency(consistency).setTimeout(timeout).setTimeoutUnit(timeoutUnit));
        }
        return ret;
    }

    public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        KVRecordReader ret = new KVRecordReader();
        ret.initialize(split, context);
        return ret;
    }

    public static void setKVStoreName(String kvStoreName) {
        KVInputFormat.kvStoreName = kvStoreName;
    }

    public static void setKVHelperHosts(String[] kvHelperHosts) {
        KVInputFormat.kvHelperHosts = kvHelperHosts;
    }

    public static void setDirection(Direction direction) {
        KVInputFormat.direction = direction;
    }

    public static void setBatchsize(int batchSize) {
        KVInputFormat.batchSize = batchSize;
    }

    public static void setParentKey(Key parentKey) {
        KVInputFormat.parentKey = parentKey;
    }

    public static void setSubRange(KeyRange subRange) {
        KVInputFormat.subRange = subRange;
    }

    public static void setDepth(Depth depth) {
        KVInputFormat.depth = depth;
    }

    public static void setConsistency(Consistency consistency) {
        if (consistency != Consistency.ABSOLUTE && consistency != Consistency.NONE_REQUIRED && consistency != null) {
            throw new IllegalArgumentException("Consistency may only be ABSOLUTE or NONE_REQUIRED");
        }
        KVInputFormat.consistency = consistency;
    }

    public static void setTimeout(long timeout) {
        KVInputFormat.timeout = timeout;
    }

    public static void setTimeoutUnit(TimeUnit timeoutUnit) {
        KVInputFormat.timeoutUnit = timeoutUnit;
    }

    static {
        direction = Direction.FORWARD;
        batchSize = 0;
        parentKey = null;
        subRange = null;
        depth = Depth.PARENT_AND_DESCENDANTS;
        consistency = null;
        timeout = 0L;
        timeoutUnit = null;
    }
}

