/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import oracle.kv.impl.util.FastExternalizable;

public class Value
implements FastExternalizable {
    private static final byte DEFAULT_FORMAT = 0;
    private final byte[] val;

    private Value(byte[] val) {
        this.val = val;
    }

    public Value(ObjectInput in, short serialVersion) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            throw new IllegalStateException("Value is zero length, format is missing");
        }
        int format = in.read();
        if (format != 0) {
            throw new IllegalStateException("Value format is " + format + ", should be " + 0);
        }
        this.val = new byte[len - 1];
        in.readFully(this.val);
    }

    public static byte[] readFastExternal(ObjectInput in, short serialVersion) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            throw new IllegalStateException("Value is zero length, format is missing");
        }
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        byte format = bytes[0];
        if (format != 0) {
            throw new IllegalStateException("Value format is " + format + ", should be " + 0);
        }
        return bytes;
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        out.writeInt(this.val.length + 1);
        out.write(0);
        out.write(this.val);
    }

    public static void writeFastExternal(ObjectOutput out, short serialVersion, byte[] bytes) throws IOException {
        if (bytes.length == 0) {
            throw new IllegalStateException("Value is zero length, format is missing");
        }
        byte format = bytes[0];
        if (format != 0) {
            throw new IllegalStateException("Value format is " + format + ", should be " + 0);
        }
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.val.length + 1];
        bytes[0] = 0;
        System.arraycopy(this.val, 0, bytes, 1, this.val.length);
        return bytes;
    }

    public static Value fromByteArray(byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalStateException("Value is zero length, format is missing");
        }
        byte format = bytes[0];
        if (format != 0) {
            throw new IllegalStateException("Value format is " + format + ", should be " + 0);
        }
        byte[] val = new byte[bytes.length - 1];
        System.arraycopy(bytes, 1, val, 0, val.length);
        return new Value(val);
    }

    public static Value createValue(byte[] val) {
        assert (val != null);
        return new Value(val);
    }

    public byte[] getValue() {
        return this.val;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Value)) {
            return false;
        }
        Value o = (Value)other;
        return Arrays.equals(this.val, o.val);
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<Value:");
        for (int i = 0; i < 100 && i < this.val.length; ++i) {
            sb.append(' ');
            sb.append(this.val[i]);
        }
        if (this.val.length > 100) {
            sb.append(" ...");
        }
        sb.append(">");
        return sb.toString();
    }
}

