/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

public class RequestLimitConfig {
    public static final int DEFAULT_MAX_ACTIVE_REQUESTS = 100;
    public static final int DEFAULT_REQUEST_THRESHOLD_PERCENT = 90;
    public static final int DEFAULT_NODE_LIMIT_PERCENT = 80;
    private final int maxActiveRequests;
    private final int requestThresholdPercent;
    private final int requestThreshold;
    private final int nodeLimitPercent;
    private final int nodeLimit;
    private static final RequestLimitConfig defaultRequestLimitConfig = new RequestLimitConfig(100, 90, 80);

    public RequestLimitConfig(int maxActiveRequests, int requestThresholdPercent, int nodeLimitPercent) {
        if (maxActiveRequests <= 0) {
            throw new IllegalArgumentException("maxActiveRequests:" + maxActiveRequests + " must be positive");
        }
        this.maxActiveRequests = maxActiveRequests;
        if (requestThresholdPercent > 100) {
            throw new IllegalArgumentException("requestThresholdPercent: " + requestThresholdPercent + "cannot exceed 100");
        }
        this.requestThresholdPercent = requestThresholdPercent;
        this.requestThreshold = maxActiveRequests * requestThresholdPercent / 100;
        if (nodeLimitPercent > requestThresholdPercent) {
            String msg = "nodeLimitPercent: " + nodeLimitPercent + "cannot exceed requestThresholdPercent: " + requestThresholdPercent;
            throw new IllegalArgumentException(msg);
        }
        this.nodeLimitPercent = nodeLimitPercent;
        this.nodeLimit = maxActiveRequests * nodeLimitPercent / 100;
    }

    public int getMaxActiveRequests() {
        return this.maxActiveRequests;
    }

    public int getRequestThresholdPercent() {
        return this.requestThresholdPercent;
    }

    public int getRequestThreshold() {
        return this.requestThreshold;
    }

    public int getNodeLimitPercent() {
        return this.nodeLimitPercent;
    }

    public int getNodeLimit() {
        return this.nodeLimit;
    }

    public String toString() {
        return String.format("maxActiveRequests=%d, requestThresholdPercent=%d%%, nodeLimitPercent=%d%%", this.maxActiveRequests, this.requestThresholdPercent, this.nodeLimitPercent);
    }

    public static RequestLimitConfig getDefault() {
        return defaultRequestLimitConfig;
    }
}

