/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.Serializable;

public class KVVersion
implements Comparable<KVVersion>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final KVVersion CURRENT_VERSION = new KVVersion(11, 2, 1, 2, 123, null);
    private final int oracleMajor;
    private final int oracleMinor;
    private final int majorNum;
    private final int minorNum;
    private final int patchNum;
    private final String name;

    public static void main(String[] argv) {
        System.out.println(CURRENT_VERSION);
    }

    private KVVersion(int oracleMajor, int oracleMinor, int majorNum, int minorNum, int patchNum, String name) {
        this.oracleMajor = oracleMajor;
        this.oracleMinor = oracleMinor;
        this.majorNum = majorNum;
        this.minorNum = minorNum;
        this.patchNum = patchNum;
        this.name = name;
    }

    public String toString() {
        return this.getVersionString();
    }

    public int getOracleMajor() {
        return this.oracleMajor;
    }

    public int getOracleMinor() {
        return this.oracleMinor;
    }

    public int getMajor() {
        return this.majorNum;
    }

    public int getMinor() {
        return this.minorNum;
    }

    public int getPatch() {
        return this.patchNum;
    }

    public String getNumericVersionString() {
        StringBuilder version = new StringBuilder();
        version.append(this.oracleMajor).append(".");
        version.append(this.oracleMinor).append(".");
        version.append(this.majorNum).append(".");
        version.append(this.minorNum).append(".");
        version.append(this.patchNum);
        return version.toString();
    }

    public String getVersionString() {
        StringBuilder version = new StringBuilder();
        version.append(this.oracleMajor).append("gR");
        version.append(this.oracleMinor).append(".");
        version.append(this.majorNum).append(".");
        version.append(this.minorNum).append(".");
        version.append(this.patchNum);
        if (this.name != null) {
            version.append(" (");
            version.append(this.name);
            version.append(")");
        }
        return version.toString();
    }

    @Override
    public int compareTo(KVVersion comparedVersion) {
        int result = 0;
        if (this.oracleMajor == comparedVersion.getOracleMajor()) {
            if (this.oracleMinor == comparedVersion.getOracleMinor()) {
                if (this.majorNum == comparedVersion.getMajor()) {
                    if (this.minorNum == comparedVersion.getMinor()) {
                        if (this.patchNum > comparedVersion.getPatch()) {
                            result = 1;
                        } else if (this.patchNum < comparedVersion.getPatch()) {
                            result = -1;
                        }
                    } else {
                        result = this.minorNum > comparedVersion.getMinor() ? 1 : -1;
                    }
                } else {
                    result = this.majorNum > comparedVersion.getMajor() ? 1 : -1;
                }
            } else {
                result = this.oracleMinor > comparedVersion.getOracleMinor() ? 1 : -1;
            }
        } else {
            result = this.oracleMajor > comparedVersion.getOracleMajor() ? 1 : -1;
        }
        return result;
    }

    public boolean equals(Object o) {
        return o instanceof KVVersion && this.compareTo((KVVersion)o) == 0;
    }

    public int hashCode() {
        return this.majorNum * 1000 * 1000 + this.minorNum * 1000 + this.patchNum;
    }
}

