/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreException;
import oracle.kv.impl.api.ClientId;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.RequestDispatcherImpl;
import oracle.kv.impl.util.client.ClientLoggerUtils;

public class KVStoreFactory {
    private static final SecureRandom secureRandom = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KVStore getStore(KVStoreConfig config) throws FaultException {
        RequestDispatcherImpl handler;
        ClientId clientId;
        SecureRandom secureRandom = KVStoreFactory.secureRandom;
        synchronized (secureRandom) {
            clientId = new ClientId(KVStoreFactory.secureRandom.nextLong());
        }
        try {
            Logger logger = ClientLoggerUtils.getLogger(KVStore.class, clientId.toString());
            KVSHandler exceptionHandler = new KVSHandler(logger);
            handler = new RequestDispatcherImpl(config, clientId, (Thread.UncaughtExceptionHandler)exceptionHandler, logger);
        }
        catch (KVStoreException e) {
            throw new FaultException(e, false);
        }
        return new KVStoreImpl(handler, (int)config.getRequestTimeout(TimeUnit.MILLISECONDS), config.getConsistency(), config.getDurability());
    }

    private static class KVSHandler
    implements Thread.UncaughtExceptionHandler {
        final Logger logger;

        public KVSHandler(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.logger.log(Level.SEVERE, "Uncaught exception in thread:" + t.getName(), e.getMessage());
        }
    }
}

